/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.serializeddata;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.serializeddata.ReflectiveConstructor;
import com.sekwah.advancedportals.core.serializeddata.ReflectiveRepresenter;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.snakeyaml.DumperOptions;
import com.sekwah.advancedportals.shadowed.snakeyaml.LoaderOptions;
import com.sekwah.advancedportals.shadowed.snakeyaml.Yaml;
import com.sekwah.advancedportals.shadowed.snakeyaml.inspector.TagInspector;
import com.sekwah.advancedportals.shadowed.snakeyaml.nodes.Tag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class DataStorage {
    private final File dataFolder;
    @Inject
    private AdvancedPortalsCore portalsCore;
    @Inject
    private InfoLogger infoLogger;

    public DataStorage(File dataStorageLoc) {
        this.dataFolder = dataStorageLoc;
    }

    private Yaml getYaml(Class<? extends Object> clazz) {
        LoaderOptions loaderOptions = new LoaderOptions();
        TagInspector tagInspector = tag -> tag.getClassName().equals(clazz.getName());
        loaderOptions.setTagInspector(tagInspector);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        ReflectiveRepresenter representer = new ReflectiveRepresenter(options);
        representer.addClassTag((Class)clazz, Tag.MAP);
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        ReflectiveConstructor<? extends Object> constructor = new ReflectiveConstructor<Object>(clazz, loaderOptions);
        AdvancedPortalsCore.getInstance().getModule().getInjector().injectMembers(constructor);
        return new Yaml(constructor, representer);
    }

    public boolean copyDefaultFile(String fileLoc) {
        return this.copyDefaultFile(fileLoc, true);
    }

    public void copyDefaultFiles(boolean override, String ... fileLocs) {
        for (String fileLoc : fileLocs) {
            this.copyDefaultFile(fileLoc, override);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T loadFile(Class<T> dataHolder, String location) {
        InputStream yamlResource = this.loadResource(location);
        if (yamlResource == null) {
            try {
                return dataHolder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        Yaml yaml = this.getYaml(dataHolder);
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(yamlResource));){
            T t = yaml.loadAs(bufReader, dataHolder);
            return t;
        }
        catch (Exception e) {
            this.infoLogger.warning("Failed to load file: " + location);
            this.infoLogger.error(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean storeFile(Object dataHolder, String location) {
        Yaml yaml = this.getYaml(dataHolder.getClass());
        File outFile = new File(this.dataFolder, location);
        try {
            if (!outFile.getCanonicalPath().startsWith(this.dataFolder.getCanonicalPath())) {
                throw new SecurityException("Attempted to store a file outside the data folder: " + location);
            }
        }
        catch (IOException e) {
            this.infoLogger.warning("Failed to validate file path: " + location);
            this.infoLogger.error(e);
            return false;
        }
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            this.infoLogger.warning("Failed to create folder for file: " + location);
        }
        String yamlFile = yaml.dump(dataHolder);
        try (FileWriter fileWriter = new FileWriter(outFile);){
            fileWriter.write(yamlFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.infoLogger.error(e);
            return false;
        }
    }

    public boolean copyDefaultFile(String fileLoc, boolean overwrite) {
        return this.copyDefaultFile(fileLoc, fileLoc, overwrite);
    }

    public boolean copyDefaultFile(String sourceLoc, String fileLoc, boolean overwrite) {
        File outFile = new File(this.dataFolder, fileLoc);
        if (!outFile.exists()) {
            outFile.getParentFile().mkdirs();
        }
        if (!outFile.exists() || overwrite) {
            try {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(sourceLoc);
                if (inputStream == null) {
                    return false;
                }
                this.writeToFile(inputStream, outFile);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                this.infoLogger.warning("Could not load " + sourceLoc + ". The file does" + "not exist or there has been an error reading the file.");
                return false;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.infoLogger.warning("Could not create " + sourceLoc);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.infoLogger.warning("File error reading " + sourceLoc);
            }
        }
        return true;
    }

    public InputStream loadResource(String location) {
        File inFile = new File(this.dataFolder, location);
        if (inFile.exists() && !inFile.isDirectory()) {
            try {
                return new FileInputStream(inFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            this.copyDefaultFile(location, false);
            return this.getClass().getClassLoader().getResourceAsStream(location);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.infoLogger.warning("Could not load " + location + ". The file does" + "not exist or there has been an error reading the file.");
            return null;
        }
    }

    public void writeResource(InputStream inputStream, String location) {
        File outFile = new File(this.dataFolder, location);
        try {
            this.writeToFile(inputStream, outFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(InputStream inputStream, File outFile) throws IOException {
        try (FileOutputStream outStream = new FileOutputStream(outFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                outStream.write(buf, 0, len);
            }
        }
        inputStream.close();
    }

    public boolean fileExists(String name) {
        return new File(this.dataFolder, name).exists();
    }

    public List<String> listAllFiles(String fileLocation, boolean trimExtension) {
        return this.listAllFiles(fileLocation, trimExtension, null);
    }

    public List<String> listAllFiles(String fileLocation, boolean trimExtension, String extension) {
        File[] files;
        File directory = new File(this.dataFolder, fileLocation);
        ArrayList<String> list = new ArrayList<String>();
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                int i;
                boolean extensionMatches;
                if (!file.isFile()) continue;
                String fileName = file.getName();
                boolean bl = extensionMatches = extension == null || fileName.endsWith("." + extension);
                if (!extensionMatches) continue;
                if (trimExtension && (i = fileName.lastIndexOf(46)) > 0) {
                    fileName = fileName.substring(0, i);
                }
                list.add(fileName);
            }
        }
        return list;
    }

    public boolean deleteFile(String fileLocation) {
        try {
            Files.delete(Paths.get(this.dataFolder.getAbsolutePath(), fileLocation));
            return true;
        }
        catch (IOException e) {
            this.infoLogger.error(e);
            return false;
        }
    }
}

