/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.serializeddata;

import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.snakeyaml.LoaderOptions;
import com.sekwah.advancedportals.shadowed.snakeyaml.constructor.Constructor;
import com.sekwah.advancedportals.shadowed.snakeyaml.nodes.MappingNode;
import com.sekwah.advancedportals.shadowed.snakeyaml.nodes.Node;
import com.sekwah.advancedportals.shadowed.snakeyaml.nodes.NodeTuple;
import com.sekwah.advancedportals.shadowed.snakeyaml.nodes.ScalarNode;
import com.sekwah.advancedportals.shadowed.snakeyaml.nodes.SequenceNode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.misc.Unsafe;

public class ReflectiveConstructor<T>
extends Constructor {
    private static final Unsafe unsafe = ReflectiveConstructor.getUnsafe();
    private final Class<T> clazz;
    @Inject
    private InfoLogger infoLogger;

    public ReflectiveConstructor(Class<T> clazz, LoaderOptions loadingConfig) {
        super(clazz, loadingConfig);
        this.clazz = clazz;
    }

    @Override
    protected Object constructObject(Node node) {
        return this.constructObject(this.clazz, node);
    }

    private Object constructObject(Class<?> currentClass, Node node) {
        if (node instanceof MappingNode) {
            return this.constructFromMappingNode(currentClass, (MappingNode)node);
        }
        if (node instanceof ScalarNode) {
            return this.constructFromScalarNode((ScalarNode)node);
        }
        if (node instanceof SequenceNode) {
            return this.constructFromSequenceNode((SequenceNode)node);
        }
        this.infoLogger.warning("Unexpected node type encountered: " + node.getClass().getSimpleName());
        return null;
    }

    private Object constructFromSequenceNode(SequenceNode sequenceNode) {
        List list = (List)super.constructObject(sequenceNode);
        if (list == null || list.isEmpty()) {
            return list;
        }
        Class<?> componentType = list.get(0).getClass();
        Object array = Array.newInstance(componentType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    private <U> Object constructFromMappingNode(Class<U> currentClass, MappingNode mappingNode) {
        if (currentClass.equals(HashMap.class)) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (NodeTuple tuple : mappingNode.getValue()) {
                String key = (String)this.constructObject(tuple.getKeyNode());
                Node node = tuple.getValueNode();
                if (node instanceof ScalarNode) {
                    Object constructedItem = this.constructFromScalarNode((ScalarNode)node);
                    values.put(key, constructedItem);
                    continue;
                }
                if (node instanceof SequenceNode) {
                    SequenceNode sequenceNode = (SequenceNode)node;
                    Object constructedItem = this.constructFromSequenceNode(sequenceNode);
                    values.put(key, constructedItem);
                    continue;
                }
                if (node instanceof MappingNode) {
                    MappingNode mappingNodeChild = (MappingNode)node;
                    try {
                        Object value = this.constructFromMappingNode(Object.class, mappingNodeChild);
                        values.put(key, value);
                    }
                    catch (Exception e) {
                        this.infoLogger.warning("Failed to construct object from mapping node: " + e.getMessage());
                    }
                    continue;
                }
                this.infoLogger.warning("Unexpected node type encountered: " + node.getClass().getSimpleName());
            }
            return values;
        }
        try {
            Field[] fields;
            Object instance;
            try {
                instance = currentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.infoLogger.info("No default constructor found for " + currentClass.getName() + ", using unsafe allocation.");
                instance = unsafe.allocateInstance(currentClass);
            }
            Map<String, Object> mappedValues = this.mapMappingNode(currentClass, mappingNode);
            for (Field field : fields = this.getAllFields(currentClass)) {
                if (Modifier.isTransient(field.getModifiers())) continue;
                try {
                    if (mappedValues.containsKey(field.getName())) {
                        Object value = mappedValues.get(field.getName());
                        this.setField(instance, field, value);
                        continue;
                    }
                    this.infoLogger.warning("Field " + field.getName() + " not found in mapping node " + instance.getClass().getName() + " will use default value.");
                }
                catch (Exception e) {
                    this.infoLogger.warning("Failed to set field " + field.getName() + " in " + currentClass.getName() + ": " + e.getMessage());
                    this.infoLogger.error(e);
                    throw new RuntimeException("Failed to set field " + field.getName() + " in " + currentClass.getName(), e);
                }
            }
            return instance;
        }
        catch (Exception e) {
            this.infoLogger.warning("Failed to instantiate " + currentClass.getName() + ": " + e.getMessage());
            throw new RuntimeException("Failed to instantiate " + currentClass.getName(), e);
        }
    }

    private Field[] getAllFields(Class<?> clazz) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                fields.putIfAbsent(field.getName(), field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.values().toArray(new Field[0]);
    }

    private Object constructFromScalarNode(ScalarNode scalarNode) {
        return super.constructObject(scalarNode);
    }

    private Map<String, Object> mapMappingNode(Class<?> currentClass, MappingNode mappingNode) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (NodeTuple tuple : mappingNode.getValue()) {
            String key = (String)super.constructObject(tuple.getKeyNode());
            Node node = tuple.getValueNode();
            if (node instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)node;
                values.put(key, this.constructFromScalarNode(scalarNode));
                continue;
            }
            if (node instanceof MappingNode) {
                MappingNode mappingNodeChild = (MappingNode)node;
                try {
                    Field field = currentClass.getDeclaredField(key);
                    Object value = this.constructFromMappingNode(field.getType(), mappingNodeChild);
                    values.put(key, value);
                }
                catch (NoSuchFieldException e) {
                    this.infoLogger.warning("Field " + key + " not found on " + currentClass.getName());
                }
                continue;
            }
            this.infoLogger.warning("Expected mapping node: " + node.getClass().getSimpleName());
        }
        return values;
    }

    private void setField(Object instance, Field field, Object value) throws IllegalAccessException {
        if (field.getType() == Float.TYPE && value instanceof Double) {
            value = Float.valueOf(((Double)value).floatValue());
        } else if (field.getType() == Integer.TYPE && value instanceof Long) {
            value = ((Long)value).intValue();
        } else if (field.getType() == Short.TYPE && value instanceof Integer) {
            value = ((Integer)value).shortValue();
        } else if (field.getType() == Byte.TYPE && value instanceof Integer) {
            value = ((Integer)value).byteValue();
        }
        field.setAccessible(true);
        field.set(instance, value);
    }

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Unsafe instance", e);
        }
    }
}

