/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.services;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.destination.Destination;
import com.sekwah.advancedportals.core.effect.WarpEffect;
import com.sekwah.advancedportals.core.registry.TagRegistry;
import com.sekwah.advancedportals.core.registry.WarpEffectRegistry;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.repository.IDestinationRepository;
import com.sekwah.advancedportals.core.serializeddata.DataTag;
import com.sekwah.advancedportals.core.serializeddata.PlayerLocation;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class DestinationServices {
    @Inject
    private IDestinationRepository destinationRepository;
    @Inject
    private WarpEffectRegistry warpEffectRegistry;
    @Inject
    private ConfigRepository configRepository;
    @Inject
    TagRegistry tagRegistry;
    private final Map<String, Destination> destinationCache = new HashMap<String, Destination>();

    public List<String> getDestinationNames() {
        return this.destinationRepository.getAllNames();
    }

    public List<Destination> getDestinations() {
        return new ArrayList<Destination>(this.destinationCache.values());
    }

    public void loadDestinations() {
        List<String> destinationNames = this.destinationRepository.getAllNames();
        this.destinationCache.clear();
        for (String name : destinationNames) {
            Destination destination = (Destination)this.destinationRepository.get(name);
            this.destinationCache.put(name, destination);
        }
    }

    public Destination createDesti(PlayerLocation playerLocation, List<DataTag> tags) {
        return this.createDesti(null, playerLocation, tags);
    }

    public Destination createDesti(PlayerContainer player, PlayerLocation playerLocation, List<DataTag> tags) {
        try {
            String name;
            DataTag nameTag = tags.stream().filter(tag -> tag.NAME.equals("name")).findFirst().orElse(null);
            String string = name = nameTag == null ? null : nameTag.VALUES[0];
            if (nameTag == null) {
                if (player != null) {
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translate("desti.error.noname"));
                }
                return null;
            }
            if (name == null || name.equals("")) {
                if (player != null) {
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.noname"));
                }
                return null;
            }
            if (this.destinationRepository.containsKey(name)) {
                if (player != null) {
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("command.error.nametaken", name));
                }
                return null;
            }
            Destination desti = new Destination(playerLocation);
            for (DataTag portalTag : tags) {
                desti.setArgValues(portalTag);
            }
            for (DataTag destiTag : tags) {
                Tag.Creation creation = this.tagRegistry.getCreationHandler(destiTag.NAME);
                if (creation == null || creation.created(desti, player, destiTag.VALUES)) continue;
                return null;
            }
            if (!this.destinationRepository.save(name, desti)) {
                return null;
            }
            this.destinationCache.put(name, desti);
            return desti;
        }
        catch (IllegalArgumentException e) {
            if (player != null) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.invalidname"));
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (player != null) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("desti.error.save"));
            }
            return null;
        }
    }

    public boolean removeDestination(String name, PlayerContainer playerContainer) {
        try {
            this.destinationRepository.delete(name);
            this.destinationCache.remove(name);
            return true;
        }
        catch (IllegalArgumentException e) {
            if (playerContainer != null) {
                playerContainer.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.invalidname"));
            }
            return false;
        }
    }

    public Destination getDestination(String name) {
        return this.destinationCache.get(name);
    }

    public boolean teleportToDestination(String name, PlayerContainer playerContainer) {
        return this.teleportToDestination(name, playerContainer, false);
    }

    public boolean teleportToDestination(String name, PlayerContainer player, boolean doEffect) {
        try {
            if (this.destinationRepository.containsKey(name)) {
                if (player.getServer().getWorld(((Destination)this.destinationRepository.get(name)).getLoc().getWorldName()) == null) {
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("desti.error.invalidworld", ((Destination)this.destinationRepository.get(name)).getName(), ((Destination)this.destinationRepository.get(name)).getLoc().getWorldName()));
                    return false;
                }
                player.teleport(((Destination)this.destinationRepository.get(name)).getLoc());
                if (doEffect && this.configRepository.getWarpEffectEnabled()) {
                    WarpEffect.Sound warpEffectSound;
                    WarpEffect.Visual warpEffectVisual = this.warpEffectRegistry.getVisualEffect(this.configRepository.getWarpVisual());
                    if (warpEffectVisual != null) {
                        warpEffectVisual.onWarpVisual(player, WarpEffect.Action.ENTER);
                    }
                    if ((warpEffectSound = this.warpEffectRegistry.getSoundEffect(this.configRepository.getWarpSound())) != null) {
                        warpEffectSound.onWarpSound(player, WarpEffect.Action.ENTER);
                    }
                }
                return true;
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.invalidname"));
            return false;
        }
    }

    public boolean renameDestination(String oldName, String newName, PlayerContainer player) {
        try {
            if (!this.destinationRepository.containsKey(oldName)) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("command.error.destination.notfound", oldName));
                return false;
            }
            if (this.destinationRepository.containsKey(newName)) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("command.error.nametaken", newName));
                return false;
            }
            Destination destination = (Destination)this.destinationRepository.get(oldName);
            this.destinationRepository.delete(oldName);
            this.destinationCache.remove(oldName);
            if (this.destinationRepository.save(newName, destination)) {
                this.destinationCache.put(newName, destination);
                player.sendMessage(Lang.getPositivePrefix() + Lang.translateInsertVariables("command.destination.rename.success", oldName, newName));
                return true;
            }
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.destination.rename.error"));
            return false;
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.invalidname"));
            return false;
        }
    }
}

