/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.services;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.repository.IPlayerDataRepository;
import com.sekwah.advancedportals.core.serializeddata.BlockLocation;
import com.sekwah.advancedportals.core.serializeddata.PlayerData;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Singleton
public final class PlayerDataServices {
    private Map<UUID, PlayerData> tempDataMap = new HashMap<UUID, PlayerData>();
    @Inject
    private IPlayerDataRepository tempDataRepository;
    @Inject
    private ConfigRepository configRepository;

    public PlayerData getPlayerData(PlayerContainer player) {
        return this.tempDataMap.computeIfAbsent(player.getUUID(), uuid -> {
            PlayerData tempData = (PlayerData)this.tempDataRepository.get(player.getUUID().toString());
            if (tempData == null) {
                tempData = new PlayerData();
            }
            return tempData;
        });
    }

    public void setJoinCooldown(PlayerContainer player) {
        PlayerData tempData = this.getPlayerData(player);
        tempData.setJoinCooldown(this.configRepository.getPortalCooldown() * 1000L);
    }

    public void playerLeave(PlayerContainer player) {
        this.tempDataRepository.save(player.getUUID().toString(), this.getPlayerData(player));
        this.tempDataMap.remove(player.getUUID());
    }

    public void playerSelectorActivate(PlayerContainer player, BlockLocation blockLoc, boolean leftClick) {
        PlayerData tempData = this.getPlayerData(player);
        if (leftClick) {
            tempData.setPos1(blockLoc);
        } else {
            tempData.setPos2(blockLoc);
        }
        player.sendMessage(Lang.translateInsertVariables("portal.selector.poschange", leftClick ? "1" : "2", blockLoc.getPosX(), blockLoc.getPosY(), blockLoc.getPosZ()));
    }
}

