/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.services;

import com.sekwah.advancedportals.core.connector.containers.GameMode;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.connector.containers.WorldContainer;
import com.sekwah.advancedportals.core.portal.AdvancedPortal;
import com.sekwah.advancedportals.core.registry.TagRegistry;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.repository.IPortalRepository;
import com.sekwah.advancedportals.core.serializeddata.BlockLocation;
import com.sekwah.advancedportals.core.serializeddata.DataTag;
import com.sekwah.advancedportals.core.serializeddata.PlayerData;
import com.sekwah.advancedportals.core.serializeddata.PlayerLocation;
import com.sekwah.advancedportals.core.services.PlayerDataServices;
import com.sekwah.advancedportals.core.tags.NameTag;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.util.PlayerUtils;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.core.warphandler.TriggerType;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.inject.Singleton;
import com.sekwah.advancedportals.shadowed.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Singleton
public class PortalServices {
    @Inject
    private IPortalRepository portalRepository;
    @Inject
    private transient PlayerDataServices playerDataServices;
    @Inject
    private ConfigRepository configRepository;
    private final Map<String, AdvancedPortal> portalCache = new HashMap<String, AdvancedPortal>();
    @Inject
    TagRegistry tagRegistry;

    public void loadPortals() {
        List<String> portalNames = this.portalRepository.getAllNames();
        this.portalCache.clear();
        for (String name : portalNames) {
            AdvancedPortal portal = (AdvancedPortal)this.portalRepository.get(name);
            if (portal == null) continue;
            this.portalCache.put(name, portal);
            portal.updateBounds(portal.getMinLoc(), portal.getMaxLoc());
        }
    }

    public boolean inPortalRegionProtected(BlockLocation loc) {
        for (AdvancedPortal portal : this.portalCache.values()) {
            if (!portal.isLocationInPortal(loc, this.configRepository.getProtectionRadius())) continue;
            return true;
        }
        return false;
    }

    public boolean inPortalRegionProtected(PlayerLocation loc) {
        for (AdvancedPortal portal : this.portalCache.values()) {
            if (!portal.isLocationInPortal(loc, this.configRepository.getProtectionRadius())) continue;
            return true;
        }
        return false;
    }

    public boolean inPortalRegion(BlockLocation loc, int extraBlocks) {
        return this.inPortalRegionGetName(loc, extraBlocks) != null;
    }

    public String inPortalRegionGetName(PlayerLocation loc, int extraBlocks) {
        return this.inPortalRegionGetName(loc.toBlockPos(), extraBlocks);
    }

    public String inPortalRegionGetName(BlockLocation loc) {
        return this.inPortalRegionGetName(loc, 0);
    }

    public String inPortalRegionGetName(BlockLocation loc, int extraBlocks) {
        for (AdvancedPortal portal : this.portalCache.values()) {
            if (!portal.isLocationInPortal(loc, extraBlocks)) continue;
            return portal.getName();
        }
        return null;
    }

    public AdvancedPortal getPortal(String portalName) {
        return this.portalCache.get(portalName);
    }

    public PortalActivationResult checkPortalActivation(PlayerContainer player, PlayerLocation toLoc, TriggerType triggerType) {
        if (this.configRepository.blockSpectatorMode() && player.getGameMode() == GameMode.SPECTATOR) {
            return PortalActivationResult.NOT_IN_PORTAL;
        }
        BlockLocation blockLoc = toLoc.toBlockPos();
        BlockLocation blockEntityTopLoc = blockLoc.addY(player.getHeight());
        WorldContainer world = player.getWorld();
        String blockMaterial = world.getBlock(blockLoc);
        boolean blockMaterialWaterlogged = world.isWaterlogged(blockLoc);
        String blockEntityTopMaterial = world.getBlock(blockEntityTopLoc);
        boolean blockEntityTopMaterialWaterlogged = world.isWaterlogged(blockEntityTopLoc);
        PlayerData playerData = this.playerDataServices.getPlayerData(player);
        for (AdvancedPortal portal : this.portalCache.values()) {
            boolean checkWaterLogged = portal.isTriggerBlock("water");
            if ((!portal.isLocationInPortal(toLoc) || (!checkWaterLogged || !blockMaterialWaterlogged) && !portal.isTriggerBlock(blockMaterial)) && (!portal.isLocationInPortal(blockEntityTopLoc) || (!checkWaterLogged || !blockEntityTopMaterialWaterlogged) && !portal.isTriggerBlock(blockEntityTopMaterial))) continue;
            String portalName = portal.getName();
            if (Objects.equals(playerData.inPortal(), portalName)) {
                return PortalActivationResult.PORTAL_DENIED;
            }
            switch (portal.activate(player, triggerType)) {
                case SUCCESS: {
                    playerData.setInPortal(portal.getName());
                    return PortalActivationResult.PORTAL_ACTIVATED;
                }
                case FAILED_DO_KNOCKBACK: {
                    playerData.setInPortal(portal.getName());
                    double strength = this.configRepository.getThrowbackStrength();
                    PlayerUtils.throwPlayerBack(player, strength);
                    return PortalActivationResult.PORTAL_DENIED;
                }
            }
        }
        if (playerData.inPortal() != null) {
            playerData.setNotInPortal();
        }
        return PortalActivationResult.NOT_IN_PORTAL;
    }

    public List<String> getPortalNames() {
        return this.portalRepository.getAllNames();
    }

    public List<AdvancedPortal> getPortals() {
        return new ArrayList<AdvancedPortal>(this.portalCache.values());
    }

    public boolean removePortal(String name, PlayerContainer player) {
        try {
            this.portalRepository.delete(name);
            this.portalCache.remove(name);
            return true;
        }
        catch (IllegalArgumentException e) {
            if (player != null) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.invalidname"));
            }
            return false;
        }
    }

    public AdvancedPortal createPortal(PlayerContainer player, ArrayList<DataTag> tags) {
        PlayerData tempData = this.playerDataServices.getPlayerData(player);
        if (tempData.getPos1() == null || tempData.getPos2() == null) {
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("portal.error.selection.missing"));
            return null;
        }
        if (!tempData.getPos1().getWorldName().equals(tempData.getPos2().getWorldName())) {
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("portal.error.selection.differentworlds"));
            return null;
        }
        return this.createPortal(player, tempData.getPos1(), tempData.getPos2(), tags);
    }

    public AdvancedPortal createPortal(@Nullable PlayerContainer player, BlockLocation pos1, BlockLocation pos2, List<DataTag> tags) {
        try {
            String name;
            DataTag nameTag = tags.stream().filter(tag -> tag.NAME.equals(NameTag.TAG_NAME)).findFirst().orElse(null);
            String string = name = nameTag == null ? null : nameTag.VALUES[0];
            if (nameTag == null || name == null || name.isEmpty()) {
                if (player != null) {
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.noname"));
                }
                return null;
            }
            if (this.portalRepository.containsKey(name)) {
                if (player != null) {
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("command.error.nametaken", name));
                }
                return null;
            }
            AdvancedPortal portal = new AdvancedPortal(pos1, pos2, this.tagRegistry, this.playerDataServices);
            for (DataTag portalTag : tags) {
                portal.setArgValues(portalTag);
            }
            for (DataTag portalTag : tags) {
                Tag.Creation creation = this.tagRegistry.getCreationHandler(portalTag.NAME);
                if (creation == null || creation.created(portal, player, portalTag.VALUES)) continue;
                return null;
            }
            if (!this.portalRepository.save(name, portal)) {
                return null;
            }
            this.portalCache.put(name, portal);
            return portal;
        }
        catch (IllegalArgumentException e) {
            if (player != null) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.invalidname"));
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (player != null) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("portal.error.save"));
            }
            return null;
        }
    }

    public boolean removePlayerSelection(PlayerContainer player) {
        return false;
    }

    public static enum PortalActivationResult {
        NOT_IN_PORTAL,
        PORTAL_TELEPORTED,
        PORTAL_ACTIVATED,
        PORTAL_DENIED;

    }
}

