/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.tags;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.network.ProxyCommandPacket;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.serializeddata.config.CommandPortalConfig;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.ActivationData;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.javax.annotation.Nullable;

public class CommandTag
implements Tag.Activation,
Tag.Split,
Tag.Creation {
    @Inject
    ConfigRepository configRepository;
    public static String TAG_NAME = "command";
    private final Tag.TagType[] tagTypes = new Tag.TagType[]{Tag.TagType.PORTAL};

    @Override
    public Tag.TagType[] getTagTypes() {
        return this.tagTypes;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    @Nullable
    public String[] getAliases() {
        return null;
    }

    @Override
    public String description() {
        return Lang.translate("tag.command.description");
    }

    @Override
    @Nullable
    public String splitString() {
        return ",";
    }

    @Override
    public boolean preActivated(TagTarget target, PlayerContainer player, ActivationData activeData, String[] argData) {
        CommandPortalConfig commandPortals = this.configRepository.getCommandPortals();
        if (!commandPortals.enabled) {
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.disabled"));
            return false;
        }
        block6: for (String command : argData) {
            char executionCommand = command.charAt(0);
            switch (executionCommand) {
                case '!': {
                    if (commandPortals.op) continue block6;
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.op.disabled"));
                    return false;
                }
                case '#': {
                    if (commandPortals.console) continue block6;
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.console.disabled"));
                    return false;
                }
                case '^': {
                    if (commandPortals.permsWildcard) continue block6;
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.permswildcard.disabled"));
                    return false;
                }
                case '%': {
                    if (commandPortals.proxy && this.configRepository.getEnableProxySupport()) continue block6;
                    player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.proxy.disabled"));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void postActivated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
        block6: for (String command : argData) {
            char executionCommand = command.charAt(0);
            String formattedCommand = command.replaceAll("@player", player.getName());
            switch (executionCommand) {
                case '!': {
                    player.getServer().dispatchCommand(player.getUUID(), formattedCommand.substring(1), CommandLevel.OP);
                    continue block6;
                }
                case '#': {
                    player.getServer().dispatchCommand(player.getUUID(), formattedCommand.substring(1), CommandLevel.CONSOLE);
                    continue block6;
                }
                case '^': {
                    player.getServer().dispatchCommand(player.getUUID(), formattedCommand.substring(1), CommandLevel.PERMISSION_WILDCARD);
                    continue block6;
                }
                case '%': {
                    ProxyCommandPacket packet = new ProxyCommandPacket(formattedCommand.substring(1));
                    player.sendPacket("advancedportals:message", packet.encode());
                    continue block6;
                }
                default: {
                    player.getServer().dispatchCommand(player.getUUID(), formattedCommand, CommandLevel.PLAYER);
                }
            }
        }
    }

    @Override
    public boolean activated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
        activationData.setWarpStatus(ActivationData.WarpedStatus.ACTIVATED);
        return true;
    }

    @Override
    public boolean created(TagTarget target, PlayerContainer player, String[] argData) {
        if (argData != null) {
            CommandPortalConfig commandPortals = this.configRepository.getCommandPortals();
            if (!commandPortals.enabled) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.disabled"));
                return false;
            }
            int n = 0;
            String[] stringArray = argData;
            int n2 = stringArray.length;
            if (n < n2) {
                String command = stringArray[n];
                char executionCommand = command.charAt(0);
                switch (executionCommand) {
                    case '!': {
                        if (!commandPortals.op) {
                            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.op.disabled"));
                            return false;
                        }
                        if (!Permissions.CREATE_COMMAND_OP.hasPermission(player)) {
                            player.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("tag.command.nopermission", "OP"));
                            return false;
                        }
                        return true;
                    }
                    case '#': {
                        if (!commandPortals.console) {
                            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.console.disabled"));
                            return false;
                        }
                        if (!Permissions.CREATE_COMMAND_CONSOLE.hasPermission(player)) {
                            player.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("tag.command.nopermission", "Console"));
                            return false;
                        }
                        return true;
                    }
                    case '^': {
                        if (!commandPortals.permsWildcard) {
                            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.command.permswildcard.disabled"));
                            return false;
                        }
                        if (!Permissions.CREATE_COMMAND_PERMS.hasPermission(player)) {
                            player.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("tag.command.nopermission", "*"));
                            return false;
                        }
                        return true;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void destroyed(TagTarget target, PlayerContainer player, String[] argData) {
    }

    public static enum CommandLevel {
        OP,
        PERMISSION_WILDCARD,
        CONSOLE,
        PLAYER;

    }
}

