/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.tags;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.services.PlayerDataServices;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.ActivationData;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.javax.annotation.Nullable;

public class PermissionTag
implements Tag.Activation {
    @Inject
    PlayerDataServices playerDataServices;
    @Inject
    ConfigRepository configRepository;
    @Inject
    private InfoLogger infoLogger;
    public static String TAG_NAME = "permission";
    private final String[] aliases = new String[]{"perm"};
    private final Tag.TagType[] tagTypes = new Tag.TagType[]{Tag.TagType.PORTAL, Tag.TagType.DESTINATION};

    @Override
    public Tag.TagType[] getTagTypes() {
        return this.tagTypes;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    @Nullable
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public String description() {
        return Lang.translate("tag.permission.description");
    }

    @Override
    public boolean preActivated(TagTarget target, PlayerContainer player, ActivationData activeData, String[] argData) {
        String permission = argData[0];
        if (permission.startsWith("!")) {
            if (player.hasPermission(permission = permission.substring(1))) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("portal.error.nopermission"));
                return false;
            }
            return true;
        }
        if (!player.hasPermission(argData[0])) {
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("portal.error.nopermission"));
            return false;
        }
        return true;
    }

    @Override
    public void postActivated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
    }

    @Override
    public boolean activated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
        return true;
    }
}

