/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.tags;

import com.sekwah.advancedportals.core.connector.containers.GameMode;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.services.PlayerDataServices;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.ActivationData;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.core.warphandler.TriggerType;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.javax.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PortalEventTag
implements Tag.Activation,
Tag.AutoComplete,
Tag.DenyBehavior,
Tag.OrderPriority {
    @Inject
    PlayerDataServices playerDataServices;
    @Inject
    ConfigRepository configRepository;
    @Inject
    private InfoLogger infoLogger;
    public static String TAG_NAME = "portalEvent";
    private final String[] aliases = new String[]{"delayed"};
    private final Tag.TagType[] tagTypes = new Tag.TagType[]{Tag.TagType.PORTAL};

    @Override
    public Tag.TagType[] getTagTypes() {
        return this.tagTypes;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    @Nullable
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public String description() {
        return Lang.translate("tag.permission.description");
    }

    @Override
    public boolean preActivated(TagTarget target, PlayerContainer player, ActivationData activeData, String[] argData) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        return !Objects.equals(argData[0], "true") || activeData.getTriggerType() == TriggerType.PORTAL;
    }

    @Override
    public void postActivated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
    }

    @Override
    public boolean activated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
        return true;
    }

    @Override
    @Nullable
    public List<String> autoComplete(String argData) {
        return Arrays.asList("true", "false");
    }

    @Override
    public Tag.DenyBehavior.Behaviour getDenyBehavior() {
        return Tag.DenyBehavior.Behaviour.SILENT;
    }

    @Override
    public Tag.Priority getPriority() {
        return Tag.Priority.HIGHEST;
    }
}

