/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.tags;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.network.Packet;
import com.sekwah.advancedportals.core.network.ProxyTransferDestiPacket;
import com.sekwah.advancedportals.core.network.ProxyTransferPacket;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.tags.DestiTag;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.ActivationData;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.Random;

public class ProxyTag
implements Tag.Activation,
Tag.OrderPriority,
Tag.Split {
    @Inject
    ConfigRepository configRepository;
    public static String TAG_NAME = "proxy";
    private final Tag.TagType[] tagTypes = new Tag.TagType[]{Tag.TagType.PORTAL};
    private final Random random = new Random();

    @Override
    public Tag.TagType[] getTagTypes() {
        return this.tagTypes;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    public String[] getAliases() {
        return null;
    }

    @Override
    public String description() {
        return Lang.translate("tag.proxy.description");
    }

    @Override
    public boolean preActivated(TagTarget target, PlayerContainer player, ActivationData activeData, String[] argData) {
        String selectedArg = argData[this.random.nextInt(argData.length)];
        activeData.setMetadata(TAG_NAME, selectedArg);
        return true;
    }

    @Override
    public void postActivated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
    }

    @Override
    public boolean activated(TagTarget target, PlayerContainer player, ActivationData activeData, String[] argData) {
        if (!this.configRepository.getEnableProxySupport()) {
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.proxy.notenabled"));
            return false;
        }
        String selectedArg = argData[this.random.nextInt(argData.length)];
        String desti = activeData.getMetadata(DestiTag.TAG_NAME);
        Packet packet = desti == null ? new ProxyTransferPacket(selectedArg) : new ProxyTransferDestiPacket(selectedArg, desti);
        player.sendPacket("advancedportals:message", packet.encode());
        activeData.setWarpStatus(ActivationData.WarpedStatus.WARPED);
        return true;
    }

    @Override
    public Tag.Priority getPriority() {
        return Tag.Priority.HIGHEST;
    }
}

