/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.tags;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.connector.containers.ServerContainer;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;

public class TriggerBlockTag
implements Tag.AutoComplete,
Tag.Split,
Tag.Creation {
    @Inject
    private ServerContainer serverContainer;
    public static final String TAG_NAME = "triggerblock";
    private final Tag.TagType[] tagTypes = new Tag.TagType[]{Tag.TagType.PORTAL};

    @Override
    public Tag.TagType[] getTagTypes() {
        return this.tagTypes;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    public String[] getAliases() {
        return null;
    }

    @Override
    public String description() {
        return Lang.translate("tag.triggerblock.description");
    }

    @Override
    public List<String> autoComplete(String argData) {
        List<String> triggerBlocks = this.serverContainer.getCommonTriggerBlocks().stream().filter(block -> block.contains(argData)).collect(Collectors.toList());
        if (triggerBlocks.isEmpty()) {
            return this.serverContainer.getAllTriggerBlocks();
        }
        return triggerBlocks;
    }

    @Override
    public boolean created(TagTarget target, PlayerContainer player, String[] argData) {
        for (int i = 0; i < argData.length; ++i) {
            String material = this.serverContainer.matchMaterialName(argData[i]);
            if (material == null || !this.isValidMaterial(material)) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.triggerblock.error.invalidmaterial"));
                return false;
            }
            argData[i] = material;
        }
        return true;
    }

    @Override
    public void destroyed(TagTarget target, PlayerContainer player, String[] argData) {
    }

    private boolean isValidMaterial(String material) {
        return this.serverContainer.getAllTriggerBlocks().stream().anyMatch(validMaterial -> validMaterial.equalsIgnoreCase(material));
    }
}

