/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.util;

import com.sekwah.advancedportals.core.serializeddata.BlockLocation;
import com.sekwah.advancedportals.shadowed.netty.buffer.ByteBuf;
import com.sekwah.advancedportals.shadowed.netty.buffer.Unpooled;
import com.sekwah.advancedportals.shadowed.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;

public class FriendlyDataOutput {
    private final ByteBuf dataOutput = Unpooled.buffer();
    private static final int PACKED_X_LENGTH = 26;
    private static final int PACKED_Z_LENGTH = 26;
    public static final int PACKED_Y_LENGTH = 12;
    private static final long PACKED_X_MASK = 0x3FFFFFFL;
    private static final long PACKED_Y_MASK = 4095L;
    private static final long PACKED_Z_MASK = 0x3FFFFFFL;
    private static final int Z_OFFSET = 12;
    private static final int X_OFFSET = 38;

    public void writeBoolean(boolean value) {
        this.dataOutput.writeBoolean(value);
    }

    public void writeByte(byte value) {
        this.dataOutput.writeByte((int)value);
    }

    public void writeShort(short value) {
        this.dataOutput.writeShort((int)value);
    }

    public void writeInt(int value) {
        this.dataOutput.writeInt(value);
    }

    public void writeLong(long value) {
        this.dataOutput.writeLong(value);
    }

    public void writeFloat(float value) {
        this.dataOutput.writeFloat(value);
    }

    public void writeDouble(double value) {
        this.dataOutput.writeDouble(value);
    }

    public void writeUtf(String text) {
        this.writeUtf(text, Short.MAX_VALUE);
    }

    public void writeUtf(String text, int maxLength) {
        int i;
        if (text.length() > maxLength) {
            throw new EncoderException("String too big (was " + text.length() + " characters, max " + maxLength + ")");
        }
        byte[] abyte = text.getBytes(StandardCharsets.UTF_8);
        if (abyte.length > (i = FriendlyDataOutput.getMaxEncodedUtfLength(maxLength))) {
            throw new EncoderException("String too big (was " + abyte.length + " bytes encoded, max " + i + ")");
        }
        this.writeVarInt(abyte.length);
        this.writeBytes(abyte);
    }

    public void writeVarInt(int p_130131_) {
        while ((p_130131_ & 0xFFFFFF80) != 0) {
            this.writeByte(p_130131_ & 0x7F | 0x80);
            p_130131_ >>>= 7;
        }
        this.writeByte(p_130131_);
    }

    public void writeBytes(byte[] p_130493_) {
        this.dataOutput.writeBytes(p_130493_);
    }

    public void writeByte(int p_130470_) {
        this.dataOutput.writeByte(p_130470_);
    }

    private static int getMaxEncodedUtfLength(int p_236871_) {
        return p_236871_ * 3;
    }

    public byte[] toByteArray() {
        if (this.dataOutput.readableBytes() <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[this.dataOutput.readableBytes()];
        this.dataOutput.readBytes(bytes);
        return bytes;
    }

    public void writeBlock(BlockLocation blockLoc) {
        this.dataOutput.writeLong(this.blockAsLong(blockLoc));
    }

    private long blockAsLong(BlockLocation blockLoc) {
        long i = 0L;
        i |= ((long)blockLoc.getPosX() & 0x3FFFFFFL) << 38;
        return (i |= ((long)blockLoc.getPosY() & 0xFFFL) << 0) | ((long)blockLoc.getPosZ() & 0x3FFFFFFL) << 12;
    }
}

