/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.util;

import com.sekwah.advancedportals.shadowed.inject.Singleton;
import java.util.ArrayList;
import java.util.Iterator;

@Singleton
public final class GameScheduler {
    private final ArrayList<DelayedGameTickEvent> newTickEvents = new ArrayList();
    private final ArrayList<DelayedGameTickEvent> delayedTickEvents = new ArrayList();

    public void tick() {
        this.delayedTickEvents.addAll(this.newTickEvents);
        this.newTickEvents.clear();
        Iterator<DelayedGameTickEvent> tickEventIterator = this.delayedTickEvents.iterator();
        while (tickEventIterator.hasNext()) {
            DelayedGameTickEvent event = tickEventIterator.next();
            event.tick();
            if (!event.shouldRun()) continue;
            event.run();
            if (event instanceof DelayedGameIntervalEvent) continue;
            tickEventIterator.remove();
        }
    }

    public void delayedTickEvent(String name, Runnable consumer, int tickDelay) {
        this.newTickEvents.add(new DelayedGameTickEvent(name, consumer, tickDelay));
    }

    public void intervalTickEvent(String name, Runnable consumer, int tickDelay, int interval) {
        this.newTickEvents.add(new DelayedGameIntervalEvent(name, consumer, tickDelay, interval));
    }

    public void clearAllEvents() {
        this.newTickEvents.clear();
        this.delayedTickEvents.clear();
    }

    public static class DelayedGameIntervalEvent
    extends DelayedGameTickEvent {
        public int interval;

        public DelayedGameIntervalEvent(String name, Runnable consumer, int ticks, int interval) {
            super(name, consumer, ticks);
            this.interval = interval;
        }

        @Override
        public void run() {
            this.ticks = this.interval;
            super.run();
        }
    }

    public static class DelayedGameTickEvent {
        public final String name;
        public final Runnable consumer;
        public int ticks;

        public DelayedGameTickEvent(String name, Runnable consumer, int ticks) {
            this.name = name;
            this.consumer = consumer;
            this.ticks = ticks;
        }

        public void tick() {
            --this.ticks;
        }

        public boolean shouldRun() {
            return this.ticks <= 0;
        }

        public void run() {
            this.consumer.run();
        }
    }
}

