/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.util;

import com.sekwah.advancedportals.core.serializeddata.DataStorage;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class Lang {
    public static final Lang instance = new Lang();
    private final HashMap<String, String> languageMap = new HashMap();
    private String negativePrefix;
    private String positivePrefix;
    @Inject
    private DataStorage dataStorage;
    @Inject
    private InfoLogger infoLogger;
    public static final String DEFAULT_LANG = "en_GB";

    public static void loadLanguage(String fileName) {
        if (!DEFAULT_LANG.equals(fileName)) {
            instance.injectTranslations(DEFAULT_LANG);
        }
        instance.injectTranslations(fileName);
        Lang.instance.negativePrefix = Lang.translate("messageprefix.negative");
        Lang.instance.positivePrefix = Lang.translate("messageprefix.positive");
    }

    public static String getNegativePrefix() {
        return Lang.instance.negativePrefix;
    }

    public static String getPositivePrefix() {
        return Lang.instance.positivePrefix;
    }

    public static String translate(String s) {
        if (Lang.instance.languageMap.containsKey(s)) {
            String translation = Lang.instance.languageMap.get(s);
            translation = Lang.convertColors(translation);
            return translation;
        }
        return s;
    }

    public static String convertColors(String s) {
        return s.replaceAll("&#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])", "&x&$1&$2&$3&$4&$5&$6").replaceAll("&([0-9a-fA-Fdwrk-ox#])", "\u00a7$1");
    }

    public static String translateInsertVariables(String s, Object ... args) {
        String translation = Lang.translate(s);
        for (int i = 1; i <= args.length; ++i) {
            translation = translation.replaceAll("%" + i + "\\$s", args[i - 1].toString());
        }
        return translation;
    }

    public Map<String, String> getLanguageMap(String fileName) {
        InputStream stream = this.dataStorage.loadResource("lang/" + fileName + ".lang");
        if (stream != null) {
            return Lang.parseLang(stream);
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getInternalLanguageMap(String fileName) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("lang/" + fileName + ".lang");
        if (stream != null) {
            return Lang.parseLang(stream);
        }
        return Collections.emptyMap();
    }

    public static int textLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static String centeredTitle(String title) {
        int titleLength = 54 - Lang.textLength(title);
        int eachSide = titleLength / 2;
        StringBuilder repeatedEquals = new StringBuilder();
        for (int i = 0; i < eachSide; ++i) {
            repeatedEquals.append("=");
        }
        return "\u00a7e" + repeatedEquals.toString() + " " + title + " \u00a7e" + repeatedEquals.toString();
    }

    private void injectTranslations(String fileName) {
        try {
            URL url = instance.getClass().getClassLoader().getResource("lang/" + fileName + ".lang");
            if (url != null) {
                Map<String, String> initialMap = Lang.parseLang(url.openStream());
                Lang.instance.languageMap.putAll(initialMap);
            } else {
                this.infoLogger.warning("Could not load " + fileName + ".lang from within Advanced Portals as it doesn't exist.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.infoLogger.warning("Could not load " + fileName + ".lang from within Advanced Portals.");
        }
        Map<String, String> newLangMap = this.getLanguageMap(fileName);
        Lang.instance.languageMap.putAll(newLangMap);
    }

    public static Map<String, String> parseLang(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        String line = Lang.getNextLine(scanner);
        HashMap<String, String> newMap = new HashMap<String, String>();
        while (line != null) {
            if (!line.startsWith("#") && line.indexOf(61) > -1) {
                int split = line.indexOf(61);
                String key = line.substring(0, split);
                String value = line.substring(split + 1);
                newMap.put(key, value);
            }
            line = Lang.getNextLine(scanner);
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newMap;
    }

    private static String getNextLine(Scanner scanner) {
        if (scanner.hasNextLine()) {
            return scanner.nextLine();
        }
        return null;
    }
}

