/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.util;

import com.sekwah.advancedportals.core.connector.containers.CommandSenderContainer;
import com.sekwah.advancedportals.core.serializeddata.DataTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TagReader {
    public static boolean isClosedString(String[] args) {
        StringBuilder currentValue = new StringBuilder();
        boolean inQuotes = false;
        for (String arg : args) {
            if (arg.contains(":") && !inQuotes) {
                int colonIndex = arg.indexOf(58);
                currentValue = new StringBuilder(arg.substring(colonIndex + 1));
                inQuotes = currentValue.toString().startsWith("\"");
            } else {
                if (currentValue.length() != 0) {
                    currentValue.append(" ");
                }
                currentValue.append(arg);
            }
            if (!inQuotes || !arg.endsWith("\"")) continue;
            inQuotes = false;
        }
        return inQuotes;
    }

    public static ArrayList<DataTag> getTagsFromArgs(String[] args) {
        ArrayList tags;
        HashMap<String, ArrayList> tagMap = new HashMap<String, ArrayList>();
        StringBuilder currentValue = new StringBuilder();
        String currentIdentifier = null;
        boolean inQuotes = false;
        for (String arg : args) {
            if (arg.contains(":") && !inQuotes) {
                if (currentIdentifier != null) {
                    ArrayList tags2;
                    if (tagMap.containsKey(currentIdentifier)) {
                        tags2 = (ArrayList)tagMap.get(currentIdentifier);
                    } else {
                        tags2 = new ArrayList();
                        tagMap.put(currentIdentifier, tags2);
                    }
                    tags2.add(currentValue.toString());
                }
                int colonIndex = arg.indexOf(58);
                currentIdentifier = arg.substring(0, colonIndex);
                currentValue = new StringBuilder(arg.substring(colonIndex + 1));
                inQuotes = currentValue.toString().startsWith("\"");
                if (inQuotes) {
                    currentValue.deleteCharAt(0);
                }
            } else {
                if (currentValue.length() != 0) {
                    currentValue.append(" ");
                }
                currentValue.append(arg);
            }
            if (!inQuotes || !arg.endsWith("\"")) continue;
            inQuotes = false;
            if (currentValue.length() <= 1) continue;
            currentValue.deleteCharAt(currentValue.length() - 1);
        }
        if (currentIdentifier != null) {
            if (tagMap.containsKey(currentIdentifier)) {
                tags = (ArrayList)tagMap.get(currentIdentifier);
            } else {
                tags = new ArrayList();
                tagMap.put(currentIdentifier, tags);
            }
            tags.add(currentValue.toString().replace("\"", ""));
        }
        tags = new ArrayList();
        for (String key : tagMap.keySet()) {
            tags.add(new DataTag(key, ((ArrayList)tagMap.get(key)).toArray(new String[0])));
        }
        return tags;
    }

    public static String getTag(String arg) {
        int splitLoc = arg.indexOf(":");
        if (splitLoc != -1) {
            return arg.substring(0, splitLoc);
        }
        return null;
    }

    public static void printArgs(CommandSenderContainer sender, List<DataTag> dataTags) {
        for (DataTag tag : dataTags) {
            if (tag.VALUES.length == 1) {
                sender.sendMessage(" \u00a7a" + tag.NAME + "\u00a77:\u00a7e" + tag.VALUES[0]);
                continue;
            }
            for (int i = 0; i < tag.VALUES.length; ++i) {
                sender.sendMessage(" \u00a7a" + tag.NAME + "\u00a77[" + i + "]:\u00a7e" + tag.VALUES[i]);
            }
        }
    }
}

