/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.warphandler;

import com.sekwah.advancedportals.core.serializeddata.PlayerLocation;
import com.sekwah.advancedportals.core.warphandler.TriggerType;
import java.util.HashMap;
import java.util.Map;

public class ActivationData {
    private boolean warpAllowed = true;
    private WarpedStatus warpStatus = WarpedStatus.NOTACTIVATED;
    private PlayerLocation wantedLocation;
    private TriggerType triggerType;
    private Map<String, String> metadata = new HashMap<String, String>();

    public WarpedStatus getWarped() {
        return this.warpStatus;
    }

    public ActivationData(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setWarpStatus(WarpedStatus warped) {
        if (this.warpStatus == WarpedStatus.WARPED || this.warpStatus == WarpedStatus.ACTIVATED && warped != WarpedStatus.WARPED) {
            return;
        }
        this.warpStatus = warped;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    public void setMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public void setWarpStatusAbsolute(WarpedStatus warped) {
        this.warpStatus = warped;
    }

    public boolean getAllowed() {
        return this.warpAllowed;
    }

    public void setAllowed(boolean allowed) {
        this.warpAllowed = allowed;
    }

    public boolean hasActivated() {
        return this.warpStatus != WarpedStatus.NOTACTIVATED;
    }

    public static enum WarpedStatus {
        WARPED,
        ACTIVATED,
        NOTACTIVATED;

    }
}

