/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.warphandler;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.warphandler.ActivationData;
import com.sekwah.advancedportals.shadowed.javax.annotation.Nullable;
import java.util.List;

public interface Tag {
    public TagType[] getTagTypes();

    public String getName();

    @Nullable
    public String[] getAliases();

    public String description();

    public static interface TagStatus
    extends Tag {
        public boolean tagAdded(TagTarget var1, PlayerContainer var2, int var3, String var4);

        public boolean tagRemoved(TagTarget var1, PlayerContainer var2, int var3, String var4);
    }

    public static interface Activation
    extends Tag {
        public boolean preActivated(TagTarget var1, PlayerContainer var2, ActivationData var3, String[] var4);

        public void postActivated(TagTarget var1, PlayerContainer var2, ActivationData var3, String[] var4);

        public boolean activated(TagTarget var1, PlayerContainer var2, ActivationData var3, String[] var4);
    }

    public static interface Creation
    extends Tag {
        public boolean created(TagTarget var1, PlayerContainer var2, String[] var3);

        public void destroyed(TagTarget var1, PlayerContainer var2, String[] var3);
    }

    public static interface Split
    extends Tag {
        @Nullable
        default public String splitString() {
            return ",";
        }
    }

    public static interface AutoComplete
    extends Tag {
        @Nullable
        public List<String> autoComplete(String var1);
    }

    public static interface DenyBehavior {
        public Behaviour getDenyBehavior();

        public static enum Behaviour {
            SILENT,
            KNOCKBACK;

        }
    }

    public static interface OrderPriority {
        public Priority getPriority();
    }

    public static enum Priority {
        HIGHEST,
        HIGH,
        NORMAL,
        LOW,
        LOWEST;

    }

    public static enum TagType {
        PORTAL,
        DESTINATION;

    }
}

