/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.legacyspigot;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.connector.commands.CommandRegister;
import com.sekwah.advancedportals.core.module.AdvancedPortalsModule;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.services.DestinationServices;
import com.sekwah.advancedportals.core.services.PortalServices;
import com.sekwah.advancedportals.core.util.GameScheduler;
import com.sekwah.advancedportals.legacyspigot.LegacySpigotInfoLogger;
import com.sekwah.advancedportals.legacyspigot.Listeners;
import com.sekwah.advancedportals.legacyspigot.commands.subcommands.portal.ImportPortalSubCommand;
import com.sekwah.advancedportals.legacyspigot.connector.command.LegacySpigotCommandRegister;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotServerContainer;
import com.sekwah.advancedportals.legacyspigot.importer.LegacyImporter;
import com.sekwah.advancedportals.legacyspigot.metrics.Metrics;
import com.sekwah.advancedportals.legacyspigot.tags.ConditionsTag;
import com.sekwah.advancedportals.legacyspigot.warpeffects.SpigotWarpEffects;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.inject.Injector;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvancedPortalsPlugin
extends JavaPlugin {
    private AdvancedPortalsCore portalsCore;
    @Inject
    DestinationServices destinationServices;
    @Inject
    PortalServices portalServices;
    @Inject
    ConfigRepository configRepo;
    private static AdvancedPortalsPlugin instance;

    public static AdvancedPortalsPlugin getInstance() {
        return instance;
    }

    public AdvancedPortalsPlugin() {
        instance = this;
    }

    public void onEnable() {
        new Metrics((Plugin)this, 4814);
        Permissions.hasPermissionManager = true;
        String mcVersion = this.getServer().getVersion();
        Pattern pattern = Pattern.compile("\\(MC: ([\\d.]+)\\)");
        Matcher matcher = pattern.matcher(mcVersion);
        LegacySpigotServerContainer serverContainer = new LegacySpigotServerContainer(this.getServer());
        this.portalsCore = new AdvancedPortalsCore(matcher.find() ? matcher.group(1) : "0.0.0", this.getDataFolder(), new LegacySpigotInfoLogger(this), serverContainer);
        AdvancedPortalsModule module = this.portalsCore.getModule();
        module.addInstanceBinding(CommandRegister.class, new LegacySpigotCommandRegister(this));
        Injector injector = module.getInjector();
        injector.injectMembers((Object)this);
        injector.injectMembers(this.portalsCore);
        injector.injectMembers(serverContainer);
        Listeners listeners = injector.getInstance(Listeners.class);
        injector.injectMembers(listeners);
        this.getServer().getPluginManager().registerEvents((Listener)listeners, (Plugin)this);
        GameScheduler scheduler = injector.getInstance(GameScheduler.class);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, scheduler::tick, 1L, 1L);
        SpigotWarpEffects warpEffects = new SpigotWarpEffects();
        injector.injectMembers(warpEffects);
        warpEffects.registerEffects();
        this.portalsCore.onEnable();
        this.portalsCore.registerPortalCommand("import", new ImportPortalSubCommand(), new String[0]);
        this.checkAndCreateConfig();
        this.registerPlaceholderAPI();
    }

    private void checkAndCreateConfig() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        File destiFile = new File(this.getDataFolder(), "destinations.yml");
        File destiFolder = new File(this.getDataFolder(), "desti");
        if (destiFile.exists() && !destiFolder.exists()) {
            destiFolder.mkdirs();
            this.getLogger().info("Importing old destinations from destinations.yml");
            LegacyImporter.importDestinations(this.destinationServices);
        }
        File portalFile = new File(this.getDataFolder(), "portals.yml");
        File portalFolder = new File(this.getDataFolder(), "portals");
        if (portalFile.exists() && !portalFolder.exists()) {
            portalFolder.mkdirs();
            this.getLogger().info("Importing old portals from portals.yml");
            LegacyImporter.importPortals(this.portalServices);
        }
        File configFile = new File(this.getDataFolder(), "config.yml");
        File configYamlFile = new File(this.getDataFolder(), "config.yaml");
        if (configFile.exists() && !configYamlFile.exists()) {
            LegacyImporter.importConfig(this.configRepo);
        }
    }

    public void onDisable() {
        this.portalsCore.onDisable();
    }

    public void registerPlaceholderAPI() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            AdvancedPortalsCore.getInstance().getTagRegistry().registerTag(new ConditionsTag());
        }
    }
}

