/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.legacyspigot;

import com.sekwah.advancedportals.core.CoreListeners;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.serializeddata.BlockLocation;
import com.sekwah.advancedportals.core.services.PortalServices;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotEntityContainer;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotPlayerContainer;
import com.sekwah.advancedportals.legacyspigot.utils.ContainerHelpers;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class Listeners
implements Listener {
    @Inject
    private CoreListeners coreListeners;
    @Inject
    private PortalServices portalServices;
    @Inject
    private ConfigRepository configRepository;

    @EventHandler
    public void onJoinEvent(PlayerJoinEvent event) {
        this.coreListeners.playerJoin(new LegacySpigotPlayerContainer(event.getPlayer()));
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        this.coreListeners.playerLeave(new LegacySpigotPlayerContainer(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMoveEvent(PlayerMoveEvent event) {
        Location to = event.getTo();
        this.coreListeners.playerMove(new LegacySpigotPlayerContainer(event.getPlayer()), ContainerHelpers.toPlayerLocation(to));
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityPortalEvent(EntityPortalEvent event) {
        if (!this.coreListeners.entityPortalEvent(new LegacySpigotEntityContainer(event.getEntity()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPortalEvent(PlayerPortalEvent event) {
        if (!this.coreListeners.playerPortalEvent(new LegacySpigotPlayerContainer(event.getPlayer()), ContainerHelpers.toPlayerLocation(event.getFrom()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamEvent(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player && (event.getCause() == EntityDamageEvent.DamageCause.LAVA || event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) && this.coreListeners.preventEntityCombust(new LegacySpigotEntityContainer(event.getEntity()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCombustEntityEvent(EntityCombustEvent event) {
        if (this.coreListeners.preventEntityCombust(new LegacySpigotEntityContainer(event.getEntity()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!event.isCancelled()) {
            Location blockloc = event.getBlock().getLocation();
            if (blockloc == null || blockloc.getWorld() == null || event.getItemInHand() == null || event.getItemInHand().getItemMeta() == null) {
                return;
            }
            String displayName = event.getItemInHand().getItemMeta().getDisplayName();
            if (!this.coreListeners.blockPlace(new LegacySpigotPlayerContainer(event.getPlayer()), new BlockLocation(blockloc.getWorld().getName(), blockloc.getBlockX(), blockloc.getBlockY(), blockloc.getBlockZ()), event.getBlockPlaced().getType().toString(), event.getItemInHand().getType().toString(), displayName)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPhysicsEvent(BlockPhysicsEvent event) {
        if (!this.coreListeners.physicsEvent(ContainerHelpers.toBlockLocation(event.getBlock().getLocation()), event.getBlock().getType().toString())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWorldChangeEvent(PlayerChangedWorldEvent event) {
        this.coreListeners.worldChange(new LegacySpigotPlayerContainer(event.getPlayer()));
    }

    @EventHandler
    public void onItemInteract(PlayerInteractEvent event) {
        if (!(event.isCancelled() || event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getItem() == null)) {
            if (event.getClickedBlock() == null) {
                return;
            }
            if (event.getItem().getItemMeta() == null) {
                return;
            }
            Location blockloc = event.getClickedBlock().getLocation();
            if (blockloc.getWorld() == null) {
                return;
            }
            boolean allowEvent = this.coreListeners.playerInteractWithBlock(new LegacySpigotPlayerContainer(event.getPlayer()), event.getClickedBlock().getType().toString(), event.getMaterial().toString(), event.getItem().getItemMeta().getDisplayName(), new BlockLocation(blockloc.getWorld().getName(), blockloc.getBlockX(), blockloc.getBlockY(), blockloc.getBlockZ()), event.getAction() == Action.LEFT_CLICK_BLOCK);
            event.setCancelled(!allowEvent);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void spawnMobEvent(CreatureSpawnEvent event) {
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NETHER_PORTAL && this.portalServices.inPortalRegionProtected(ContainerHelpers.toPlayerLocation(event.getLocation()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (!this.configRepository.getStopWaterFlow()) {
            return;
        }
        if (!this.coreListeners.blockPlace(null, ContainerHelpers.toBlockLocation(event.getBlock().getLocation()), event.getBlock().getType().toString(), null, null) || !this.coreListeners.blockPlace(null, ContainerHelpers.toBlockLocation(event.getToBlock().getLocation()), event.getBlock().getType().toString(), null, null)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        ItemStack itemInHand = event.getPlayer().getItemInHand();
        if (!this.coreListeners.blockBreak(new LegacySpigotPlayerContainer(event.getPlayer()), ContainerHelpers.toBlockLocation(event.getBlock().getLocation()), event.getBlock().getType().toString(), itemInHand == null ? null : itemInHand.getType().toString(), itemInHand == null || itemInHand.getItemMeta() == null ? null : itemInHand.getItemMeta().getDisplayName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onExplosion(EntityExplodeEvent event) {
        if (!this.configRepository.getPortalProtection()) {
            return;
        }
        List blockList = event.blockList();
        for (int i = 0; i < blockList.size(); ++i) {
            Block block = (Block)blockList.get(i);
            if (!this.portalServices.inPortalRegionProtected(ContainerHelpers.toBlockLocation(block.getLocation()))) continue;
            blockList.remove(i);
            --i;
        }
    }
}

