/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.legacyspigot;

import com.sekwah.advancedportals.core.permissions.PermissionBuilder;
import com.sekwah.advancedportals.core.permissions.Permissions;
import java.util.List;

public class PermissionsGeneratorSpigot {
    private PermissionsGeneratorSpigot() {
    }

    public static String getPermissions() {
        return PermissionsGeneratorSpigot.toPermBlock(Permissions.ROOT);
    }

    public static String toPermBlock(PermissionBuilder permission) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        String indent = "  ";
        if (!permission.isDoNotExport()) {
            List<PermissionBuilder> children;
            builder.append(indent).append(permission).append(":\n");
            builder.append(indent).append(indent).append("default: ");
            builder.append(permission.getPermissionDefault().toString().toLowerCase());
            builder.append("\n");
            if (permission.getDescription() != null) {
                builder.append(indent).append(indent).append("description: ");
                builder.append(permission.getDescription()).append("\n");
            }
            if (!(children = permission.getGrantChildren()).isEmpty()) {
                builder.append(indent).append(indent).append("children:\n");
                for (PermissionBuilder child : children) {
                    builder.append(indent).append(indent).append(indent);
                    builder.append(child.toString()).append(": true").append("\n");
                }
            }
        }
        for (PermissionBuilder child : permission.getChildren()) {
            builder.append(PermissionsGeneratorSpigot.toPermBlock(child));
        }
        return builder.toString();
    }
}

