/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.legacyspigot.connector.container;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.connector.containers.GameMode;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.connector.containers.ServerContainer;
import com.sekwah.advancedportals.core.serializeddata.PlayerLocation;
import com.sekwah.advancedportals.core.serializeddata.Vector;
import com.sekwah.advancedportals.legacyspigot.AdvancedPortalsPlugin;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotEntityContainer;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotServerContainer;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.awt.Color;
import java.util.Arrays;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class LegacySpigotPlayerContainer
extends LegacySpigotEntityContainer
implements PlayerContainer {
    @Inject
    private AdvancedPortalsCore portalsCore;
    private final Player player;

    public LegacySpigotPlayerContainer(Player player) {
        super((Entity)player);
        this.player = player;
    }

    @Override
    public UUID getUUID() {
        return this.player.getUniqueId();
    }

    @Override
    public void sendMessage(String message) {
        this.player.sendMessage(message);
    }

    @Override
    public void sendActionBar(String message) {
        try {
            this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
        catch (NoSuchMethodError e) {
            this.player.sendMessage(message);
        }
    }

    @Override
    public boolean isOp() {
        return this.player.isOp();
    }

    @Override
    public boolean teleport(PlayerLocation location) {
        return this.player.teleport(new Location(Bukkit.getWorld((String)location.getWorldName()), location.getPosX(), location.getPosY(), location.getPosZ(), location.getYaw(), location.getPitch()));
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    public void giveItem(String material, String itemName, String ... itemDescription) {
        ItemStack regionselector = new ItemStack(Material.getMaterial((String)material));
        ItemMeta selectorname = regionselector.getItemMeta();
        selectorname.setDisplayName(itemName);
        selectorname.setLore(Arrays.asList(itemDescription));
        regionselector.setItemMeta(selectorname);
        this.player.getInventory().addItem(new ItemStack[]{regionselector});
    }

    @Override
    public boolean sendPacket(String channel, byte[] bytes) {
        this.player.sendPluginMessage((Plugin)AdvancedPortalsPlugin.getInstance(), channel, bytes);
        return true;
    }

    @Override
    public GameMode getGameMode() {
        try {
            return GameMode.valueOf(this.player.getGameMode().name());
        }
        catch (IllegalArgumentException e) {
            return GameMode.SURVIVAL;
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void playSound(String sound, float volume, float pitch) {
        this.player.playSound(this.player.getLocation(), sound, volume, pitch);
    }

    @Override
    public ServerContainer getServer() {
        return new LegacySpigotServerContainer(this.player.getServer());
    }

    @Override
    public void spawnColoredDust(Vector position, double xSpread, double ySpread, double zSpread, int count, Color color) {
        Location location = new Location(this.player.getWorld(), position.getX(), position.getY(), position.getZ());
        if (this.player.getLocation().distance(location) > 180.0) {
            return;
        }
        if (color.getRed() == 0) {
            color = new Color(1, color.getGreen(), color.getBlue());
        }
        this.player.spigot().playEffect(new Location(this.player.getWorld(), position.getX(), position.getY(), position.getZ()), Effect.COLOURED_DUST, 0, 0, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, 0, 64);
    }
}

