/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.legacyspigot.connector.container;

import com.sekwah.advancedportals.core.CoreListeners;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.connector.containers.ServerContainer;
import com.sekwah.advancedportals.core.connector.containers.WorldContainer;
import com.sekwah.advancedportals.core.tags.CommandTag;
import com.sekwah.advancedportals.legacyspigot.AdvancedPortalsPlugin;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotPlayerContainer;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotWorldContainer;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class LegacySpigotServerContainer
implements ServerContainer {
    @Inject
    private CoreListeners coreListeners;
    private final Server server;
    private final List<String> commonTriggerBlockList = Stream.of(Material.WATER, Material.LAVA, Material.AIR, Material.PORTAL, Material.ENDER_PORTAL).map(Enum::name).collect(Collectors.toList());
    private final List<String> fullTriggerBlockList = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList());

    public LegacySpigotServerContainer(Server server) {
        this.server = server;
    }

    @Override
    public WorldContainer getWorld(String name) {
        World world = this.server.getWorld(name);
        if (world != null) {
            return new LegacySpigotWorldContainer(world);
        }
        return null;
    }

    @Override
    public PlayerContainer getPlayer(String name) {
        Player player = this.server.getPlayer(name);
        if (player != null) {
            return new LegacySpigotPlayerContainer(player);
        }
        return null;
    }

    @Override
    public PlayerContainer getPlayer(UUID name) {
        Player player = this.server.getPlayer(name);
        if (player != null) {
            return new LegacySpigotPlayerContainer(player);
        }
        return null;
    }

    @Override
    public List<String> getAllTriggerBlocks() {
        return this.fullTriggerBlockList;
    }

    @Override
    public List<String> getCommonTriggerBlocks() {
        return this.commonTriggerBlockList;
    }

    @Override
    public PlayerContainer[] getPlayers() {
        return (PlayerContainer[])this.server.getOnlinePlayers().stream().map(LegacySpigotPlayerContainer::new).toArray(PlayerContainer[]::new);
    }

    @Override
    public void registerOutgoingChannel(String channel) {
        this.server.getMessenger().registerOutgoingPluginChannel((Plugin)AdvancedPortalsPlugin.getInstance(), channel);
    }

    @Override
    public void registerIncomingChannel(String channel) {
        this.server.getMessenger().registerIncomingPluginChannel((Plugin)AdvancedPortalsPlugin.getInstance(), channel, (s, player, bytes) -> this.coreListeners.incomingMessage(new LegacySpigotPlayerContainer(player), s, bytes));
    }

    @Override
    public void dispatchCommand(UUID uuid, String command, CommandTag.CommandLevel commandLevel) {
        Player player = this.server.getPlayer(uuid);
        switch (commandLevel) {
            case CONSOLE: {
                this.server.dispatchCommand((CommandSender)this.server.getConsoleSender(), command);
                break;
            }
            case PLAYER: {
                this.server.dispatchCommand((CommandSender)player, command);
                break;
            }
            case OP: 
            case PERMISSION_WILDCARD: {
                this.executeCommandWithPermission(player, this.server, command, commandLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommandWithPermission(Player player, Server server, String command, CommandTag.CommandLevel commandLevel) {
        switch (commandLevel) {
            case PERMISSION_WILDCARD: {
                if (player.hasPermission("*")) {
                    server.dispatchCommand((CommandSender)player, command);
                    return;
                }
                PermissionAttachment permissionAttachment = player.addAttachment(server.getPluginManager().getPlugin("AdvancedPortals"));
                try {
                    permissionAttachment.setPermission("*", true);
                    server.dispatchCommand((CommandSender)player, command);
                    break;
                }
                finally {
                    player.removeAttachment(permissionAttachment);
                }
            }
            case OP: {
                if (player.isOp()) {
                    server.dispatchCommand((CommandSender)player, command);
                    return;
                }
                try {
                    player.setOp(true);
                    server.dispatchCommand((CommandSender)player, command);
                    break;
                }
                finally {
                    player.setOp(false);
                }
            }
        }
    }

    @Override
    public String matchMaterialName(String materialName) {
        return Arrays.stream(Material.values()).map(Enum::name).filter(name -> name.equalsIgnoreCase(materialName)).findFirst().orElse(null);
    }
}

