/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.legacyspigot.tags;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.ActivationData;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotPlayerContainer;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class ConditionsTag
implements Tag.Activation,
Tag.Split,
Tag.Creation {
    @Inject
    private InfoLogger infoLogger;

    @Override
    public boolean preActivated(TagTarget target, PlayerContainer player, ActivationData activeData, String[] argData) {
        for (String condition : argData) {
            LegacySpigotPlayerContainer spigotPlayer;
            if (!(player instanceof LegacySpigotPlayerContainer) || this.checkConditions(condition, (spigotPlayer = (LegacySpigotPlayerContainer)player).getPlayer())) continue;
            spigotPlayer.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.conditions.fail"));
            return false;
        }
        return true;
    }

    @Override
    public void postActivated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
    }

    @Override
    public boolean activated(TagTarget target, PlayerContainer player, ActivationData activationData, String[] argData) {
        return false;
    }

    @Override
    public Tag.TagType[] getTagTypes() {
        return new Tag.TagType[]{Tag.TagType.PORTAL};
    }

    @Override
    public String getName() {
        return "conditions";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public String description() {
        return Lang.translate("tag.conditions.description");
    }

    private boolean checkConditions(String condition, Player player) {
        String trimmedCondition = condition.replaceAll("\\s+", "");
        if (!trimmedCondition.matches(".*(<=|>=|<|>|==).*")) {
            this.infoLogger.warning("Invalid operator: " + condition);
            return false;
        }
        String[] parts = trimmedCondition.split("<=|>=|<|>|==");
        if (parts.length == 2) {
            String placeholder = parts[0].trim();
            String actualValue = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
            String restOfCondition = parts[1].trim();
            String operator = condition.substring(placeholder.length(), condition.length() - restOfCondition.length()).trim();
            return this.performComparison(actualValue, operator, restOfCondition);
        }
        this.infoLogger.warning("Invalid condition format: " + condition);
        return false;
    }

    private boolean performComparison(String actualValue, String operator, String expectedValue) {
        if (this.isNumeric(actualValue) && this.isNumeric(expectedValue)) {
            double actualNumeric = Double.parseDouble(actualValue);
            double expectedNumeric = Double.parseDouble(expectedValue);
            switch (operator) {
                case "==": {
                    return actualNumeric == expectedNumeric;
                }
                case "<": {
                    return actualNumeric < expectedNumeric;
                }
                case ">": {
                    return actualNumeric > expectedNumeric;
                }
                case "<=": {
                    return actualNumeric <= expectedNumeric;
                }
                case ">=": {
                    return actualNumeric >= expectedNumeric;
                }
            }
            return false;
        }
        if (this.isBoolean(actualValue) && this.isBoolean(expectedValue)) {
            boolean expectedBoolean;
            boolean actualBoolean = Boolean.parseBoolean(actualValue);
            return actualBoolean == (expectedBoolean = Boolean.parseBoolean(expectedValue));
        }
        return actualValue.equals(expectedValue);
    }

    private boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isBoolean(String str) {
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false");
    }

    @Override
    public boolean created(TagTarget target, PlayerContainer player, String[] argData) {
        for (String condition : argData) {
            LegacySpigotPlayerContainer spigotPlayer;
            if (!(player instanceof LegacySpigotPlayerContainer) || this.checkConditions(condition, (spigotPlayer = (LegacySpigotPlayerContainer)player).getPlayer())) continue;
            spigotPlayer.sendMessage(Lang.getNegativePrefix() + Lang.translate("tag.conditions.invalid"));
            return false;
        }
        return true;
    }

    @Override
    public void destroyed(TagTarget target, PlayerContainer player, String[] argData) {
    }
}

