/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.legacyspigot.warpeffects;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.effect.WarpEffect;
import com.sekwah.advancedportals.legacyspigot.AdvancedPortalsPlugin;
import com.sekwah.advancedportals.legacyspigot.connector.container.LegacySpigotPlayerContainer;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class EnderWarpEffect
implements WarpEffect.Visual,
WarpEffect.Sound {
    Sound sound;

    public EnderWarpEffect() {
        try {
            this.sound = Sound.valueOf((String)"ENTITY_ENDERMEN_TELEPORT");
        }
        catch (IllegalArgumentException e) {
            try {
                this.sound = Sound.valueOf((String)"ENDERMAN_TELEPORT");
            }
            catch (IllegalArgumentException e2) {
                AdvancedPortalsPlugin.getInstance().getLogger().warning("Could not find the sound ENTITY_ENDERMAN_TELEPORT or ENDERMAN_TELEPORT");
            }
        }
    }

    @Override
    public void onWarpSound(PlayerContainer playerContainer, WarpEffect.Action action) {
        if (playerContainer instanceof LegacySpigotPlayerContainer) {
            LegacySpigotPlayerContainer spigotPlayerContainer = (LegacySpigotPlayerContainer)playerContainer;
            Player player = spigotPlayerContainer.getPlayer();
            if (this.sound == null) {
                return;
            }
            player.getWorld().playSound(player.getLocation(), this.sound, 1.0f, 1.0f);
        }
    }

    @Override
    public void onWarpVisual(PlayerContainer playerContainer, WarpEffect.Action action) {
        if (playerContainer instanceof LegacySpigotPlayerContainer) {
            int i;
            LegacySpigotPlayerContainer spigotPlayerContainer = (LegacySpigotPlayerContainer)playerContainer;
            Player player = spigotPlayerContainer.getPlayer();
            World world = player.getWorld();
            Location loc = player.getLocation().clone();
            for (i = 0; i < 10; ++i) {
                world.playEffect(loc, Effect.ENDER_SIGNAL, 0);
            }
            loc.add(0.0, 1.0, 0.0);
            for (i = 0; i < 10; ++i) {
                world.playEffect(loc, Effect.ENDER_SIGNAL, 0);
            }
        }
    }
}

