/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.guava.collect;

import com.google.j2objc.annotations.Weak;
import com.sekwah.advancedportals.shadowed.guava.annotations.GwtCompatible;
import com.sekwah.advancedportals.shadowed.guava.base.Objects;
import com.sekwah.advancedportals.shadowed.guava.base.Preconditions;
import com.sekwah.advancedportals.shadowed.guava.base.Predicate;
import com.sekwah.advancedportals.shadowed.guava.base.Predicates;
import com.sekwah.advancedportals.shadowed.guava.collect.ElementTypesAreNonnullByDefault;
import com.sekwah.advancedportals.shadowed.guava.collect.FilteredMultimap;
import com.sekwah.advancedportals.shadowed.guava.collect.Iterables;
import com.sekwah.advancedportals.shadowed.guava.collect.Maps;
import com.sekwah.advancedportals.shadowed.javax.annotation.CheckForNull;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class FilteredMultimapValues<K, V>
extends AbstractCollection<V> {
    @Weak
    private final FilteredMultimap<K, V> multimap;

    FilteredMultimapValues(FilteredMultimap<K, V> multimap) {
        this.multimap = Preconditions.checkNotNull(multimap);
    }

    @Override
    public Iterator<V> iterator() {
        return Maps.valueIterator(this.multimap.entries().iterator());
    }

    @Override
    public boolean contains(@CheckForNull Object o) {
        return this.multimap.containsValue(o);
    }

    @Override
    public int size() {
        return this.multimap.size();
    }

    @Override
    public boolean remove(@CheckForNull Object o) {
        Predicate<Map.Entry<K, V>> entryPredicate = this.multimap.entryPredicate();
        Iterator<Map.Entry<K, V>> unfilteredItr = this.multimap.unfiltered().entries().iterator();
        while (unfilteredItr.hasNext()) {
            Map.Entry<K, V> entry = unfilteredItr.next();
            if (!entryPredicate.apply(entry) || !Objects.equal(entry.getValue(), o)) continue;
            unfilteredItr.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return Iterables.removeIf(this.multimap.unfiltered().entries(), Predicates.and(this.multimap.entryPredicate(), Maps.valuePredicateOnEntries(Predicates.in(c))));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return Iterables.removeIf(this.multimap.unfiltered().entries(), Predicates.and(this.multimap.entryPredicate(), Maps.valuePredicateOnEntries(Predicates.not(Predicates.in(c)))));
    }

    @Override
    public void clear() {
        this.multimap.clear();
    }
}

