/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.guava.collect;

import com.sekwah.advancedportals.shadowed.errorprone.annotations.CanIgnoreReturnValue;
import com.sekwah.advancedportals.shadowed.errorprone.annotations.CompatibleWith;
import com.sekwah.advancedportals.shadowed.errorprone.annotations.DoNotMock;
import com.sekwah.advancedportals.shadowed.guava.annotations.GwtCompatible;
import com.sekwah.advancedportals.shadowed.guava.base.Preconditions;
import com.sekwah.advancedportals.shadowed.guava.collect.ElementTypesAreNonnullByDefault;
import com.sekwah.advancedportals.shadowed.guava.collect.Multiset;
import com.sekwah.advancedportals.shadowed.guava.collect.ParametricNullness;
import com.sekwah.advancedportals.shadowed.javax.annotation.CheckForNull;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

@DoNotMock(value="Use ImmutableMultimap, HashMultimap, or another implementation")
@ElementTypesAreNonnullByDefault
@GwtCompatible
public interface Multimap<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(@CheckForNull @CompatibleWith(value="K") Object var1);

    public boolean containsValue(@CheckForNull @CompatibleWith(value="V") Object var1);

    public boolean containsEntry(@CheckForNull @CompatibleWith(value="K") Object var1, @CheckForNull @CompatibleWith(value="V") Object var2);

    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness K var1, @ParametricNullness V var2);

    @CanIgnoreReturnValue
    public boolean remove(@CheckForNull @CompatibleWith(value="K") Object var1, @CheckForNull @CompatibleWith(value="V") Object var2);

    @CanIgnoreReturnValue
    public boolean putAll(@ParametricNullness K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public boolean putAll(Multimap<? extends K, ? extends V> var1);

    @CanIgnoreReturnValue
    public Collection<V> replaceValues(@ParametricNullness K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public Collection<V> removeAll(@CheckForNull @CompatibleWith(value="K") Object var1);

    public void clear();

    public Collection<V> get(@ParametricNullness K var1);

    public Set<K> keySet();

    public Multiset<K> keys();

    public Collection<V> values();

    public Collection<Map.Entry<K, V>> entries();

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries().forEach((? super T entry) -> action.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public Map<K, Collection<V>> asMap();

    public boolean equals(@CheckForNull Object var1);

    public int hashCode();
}

