/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.guava.collect;

import com.sekwah.advancedportals.shadowed.guava.annotations.GwtCompatible;
import com.sekwah.advancedportals.shadowed.guava.annotations.GwtIncompatible;
import com.sekwah.advancedportals.shadowed.guava.annotations.J2ktIncompatible;
import com.sekwah.advancedportals.shadowed.guava.base.Preconditions;
import com.sekwah.advancedportals.shadowed.guava.collect.ElementTypesAreNonnullByDefault;
import com.sekwah.advancedportals.shadowed.guava.collect.ImmutableList;
import com.sekwah.advancedportals.shadowed.guava.collect.Iterators;
import com.sekwah.advancedportals.shadowed.guava.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Spliterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableList<E>
extends ImmutableList<E> {
    final transient E element;

    SingletonImmutableList(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, 1);
        return fromIndex == toIndex ? ImmutableList.of() : this;
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

