/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.inject.internal;

import com.sekwah.advancedportals.shadowed.guava.collect.ImmutableList;
import com.sekwah.advancedportals.shadowed.inject.internal.ConstructionProxyFactory;
import com.sekwah.advancedportals.shadowed.inject.internal.ConstructorInjector;
import com.sekwah.advancedportals.shadowed.inject.internal.DefaultConstructionProxyFactory;
import com.sekwah.advancedportals.shadowed.inject.internal.Errors;
import com.sekwah.advancedportals.shadowed.inject.internal.ErrorsException;
import com.sekwah.advancedportals.shadowed.inject.internal.FailableCache;
import com.sekwah.advancedportals.shadowed.inject.internal.InjectorImpl;
import com.sekwah.advancedportals.shadowed.inject.internal.InternalFlags;
import com.sekwah.advancedportals.shadowed.inject.internal.MembersInjectorImpl;
import com.sekwah.advancedportals.shadowed.inject.internal.MethodAspect;
import com.sekwah.advancedportals.shadowed.inject.internal.ProxyFactory;
import com.sekwah.advancedportals.shadowed.inject.internal.SingleParameterInjector;
import com.sekwah.advancedportals.shadowed.inject.spi.InjectionPoint;
import java.util.stream.Stream;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ConstructionProxyFactory factory = null;
        if (InternalFlags.isBytecodeGenEnabled()) {
            ImmutableList<MethodAspect> injectorAspects = this.injector.getBindingData().getMethodAspects();
            ImmutableList<MethodAspect> methodAspects = membersInjector.getAddedAspects().isEmpty() ? injectorAspects : Stream.concat(injectorAspects.stream(), membersInjector.getAddedAspects().stream()).collect(ImmutableList.toImmutableList());
            factory = new ProxyFactory(injectionPoint, methodAspects);
        } else {
            factory = new DefaultConstructionProxyFactory(injectionPoint);
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

