/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.inject.internal;

import com.sekwah.advancedportals.shadowed.guava.collect.ImmutableList;
import com.sekwah.advancedportals.shadowed.guava.collect.Lists;
import com.sekwah.advancedportals.shadowed.inject.ConfigurationException;
import com.sekwah.advancedportals.shadowed.inject.Stage;
import com.sekwah.advancedportals.shadowed.inject.TypeLiteral;
import com.sekwah.advancedportals.shadowed.inject.internal.AbstractProcessor;
import com.sekwah.advancedportals.shadowed.inject.internal.Errors;
import com.sekwah.advancedportals.shadowed.inject.internal.Initializer;
import com.sekwah.advancedportals.shadowed.inject.internal.InjectorImpl;
import com.sekwah.advancedportals.shadowed.inject.internal.InternalContext;
import com.sekwah.advancedportals.shadowed.inject.internal.InternalProvisionException;
import com.sekwah.advancedportals.shadowed.inject.internal.SingleMemberInjector;
import com.sekwah.advancedportals.shadowed.inject.spi.InjectionRequest;
import com.sekwah.advancedportals.shadowed.inject.spi.StaticInjectionRequest;
import java.util.List;
import java.util.Set;

final class InjectionRequestProcessor
extends AbstractProcessor {
    private final List<StaticInjection> staticInjections = Lists.newArrayList();
    private final Initializer initializer;

    InjectionRequestProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public Boolean visit(StaticInjectionRequest request) {
        this.staticInjections.add(new StaticInjection(this.injector, request));
        this.injector.getBindingData().putStaticInjectionRequest(request);
        return true;
    }

    @Override
    public Boolean visit(InjectionRequest<?> request) {
        Set injectionPoints;
        try {
            injectionPoints = request.getInjectionPoints();
        }
        catch (ConfigurationException e) {
            this.errors.merge(e.getErrorMessages());
            injectionPoints = (Set)e.getPartialValue();
        }
        this.initializer.requestInjection(this.injector, request.getInstance(), null, request.getSource(), injectionPoints);
        this.injector.getBindingData().putInjectionRequest(new InjectionRequest<Object>(request.getSource(), TypeLiteral.get(request.getInstance().getClass()), null));
        return true;
    }

    void validate() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.validate();
        }
    }

    void injectMembers() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.injectMembers();
        }
    }

    private class StaticInjection {
        final InjectorImpl injector;
        final Object source;
        final StaticInjectionRequest request;
        ImmutableList<SingleMemberInjector> memberInjectors;

        public StaticInjection(InjectorImpl injector, StaticInjectionRequest request) {
            this.injector = injector;
            this.source = request.getSource();
            this.request = request;
        }

        void validate() {
            Set injectionPoints;
            Errors errorsForMember = InjectionRequestProcessor.this.errors.withSource(this.source);
            try {
                injectionPoints = this.request.getInjectionPoints();
            }
            catch (ConfigurationException e) {
                errorsForMember.merge(e.getErrorMessages());
                injectionPoints = (Set)e.getPartialValue();
            }
            this.memberInjectors = injectionPoints != null ? this.injector.membersInjectorStore.getInjectors(injectionPoints, errorsForMember) : ImmutableList.of();
            InjectionRequestProcessor.this.errors.merge(errorsForMember);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void injectMembers() {
            try (InternalContext context = this.injector.enterContext();){
                boolean isStageTool = this.injector.options.stage == Stage.TOOL;
                for (SingleMemberInjector memberInjector : this.memberInjectors) {
                    if (isStageTool && !memberInjector.getInjectionPoint().isToolable()) continue;
                    try {
                        memberInjector.inject(context, null);
                    }
                    catch (InternalProvisionException e) {
                        InjectionRequestProcessor.this.errors.merge(e);
                    }
                }
            }
        }
    }
}

