/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.inject.internal;

import com.sekwah.advancedportals.shadowed.guava.base.Preconditions;
import com.sekwah.advancedportals.shadowed.inject.Stage;
import com.sekwah.advancedportals.shadowed.inject.internal.AbstractProcessor;
import com.sekwah.advancedportals.shadowed.inject.internal.Errors;
import com.sekwah.advancedportals.shadowed.inject.internal.InjectorImpl;
import com.sekwah.advancedportals.shadowed.inject.spi.DisableCircularProxiesOption;
import com.sekwah.advancedportals.shadowed.inject.spi.RequireAtInjectOnConstructorsOption;
import com.sekwah.advancedportals.shadowed.inject.spi.RequireExactBindingAnnotationsOption;
import com.sekwah.advancedportals.shadowed.inject.spi.RequireExplicitBindingsOption;

class InjectorOptionsProcessor
extends AbstractProcessor {
    private boolean disableCircularProxies = false;
    private boolean jitDisabled = false;
    private boolean atInjectRequired = false;
    private boolean exactBindingAnnotationsRequired = false;

    InjectorOptionsProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(DisableCircularProxiesOption option) {
        this.disableCircularProxies = true;
        return true;
    }

    @Override
    public Boolean visit(RequireExplicitBindingsOption option) {
        this.jitDisabled = true;
        return true;
    }

    @Override
    public Boolean visit(RequireAtInjectOnConstructorsOption option) {
        this.atInjectRequired = true;
        return true;
    }

    @Override
    public Boolean visit(RequireExactBindingAnnotationsOption option) {
        this.exactBindingAnnotationsRequired = true;
        return true;
    }

    InjectorImpl.InjectorOptions getOptions(Stage stage, InjectorImpl.InjectorOptions parentOptions) {
        Preconditions.checkNotNull(stage, "stage must be set");
        if (parentOptions == null) {
            return new InjectorImpl.InjectorOptions(stage, this.jitDisabled, this.disableCircularProxies, this.atInjectRequired, this.exactBindingAnnotationsRequired);
        }
        Preconditions.checkState(stage == parentOptions.stage, "child & parent stage don't match");
        return new InjectorImpl.InjectorOptions(stage, this.jitDisabled || parentOptions.jitDisabled, this.disableCircularProxies || parentOptions.disableCircularProxies, this.atInjectRequired || parentOptions.atInjectRequired, this.exactBindingAnnotationsRequired || parentOptions.exactBindingAnnotationsRequired);
    }
}

