/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.inject.internal;

import com.sekwah.advancedportals.shadowed.inject.Guice;
import com.sekwah.advancedportals.shadowed.inject.internal.AbstractProcessor;
import com.sekwah.advancedportals.shadowed.inject.internal.Errors;
import com.sekwah.advancedportals.shadowed.inject.spi.Message;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MessageProcessor
extends AbstractProcessor {
    private static final Logger logger = Logger.getLogger(Guice.class.getName());

    MessageProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(Message message) {
        if (message.getCause() != null) {
            String rootMessage = MessageProcessor.getRootMessage(message.getCause());
            String string = String.valueOf(rootMessage);
            logger.log(Level.INFO, string.length() != 0 ? "An exception was caught and reported. Message: ".concat(string) : new String("An exception was caught and reported. Message: "), message.getCause());
        }
        this.errors.addMessage(message);
        return true;
    }

    public static String getRootMessage(Throwable t) {
        Throwable cause = t.getCause();
        return cause == null ? t.toString() : MessageProcessor.getRootMessage(cause);
    }
}

