/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.inject.internal;

import com.sekwah.advancedportals.shadowed.guava.base.Objects;
import com.sekwah.advancedportals.shadowed.guava.base.Preconditions;
import com.sekwah.advancedportals.shadowed.guava.collect.HashMultimap;
import com.sekwah.advancedportals.shadowed.guava.collect.ImmutableList;
import com.sekwah.advancedportals.shadowed.guava.collect.ImmutableSet;
import com.sekwah.advancedportals.shadowed.inject.Binder;
import com.sekwah.advancedportals.shadowed.inject.Key;
import com.sekwah.advancedportals.shadowed.inject.Module;
import com.sekwah.advancedportals.shadowed.inject.Provides;
import com.sekwah.advancedportals.shadowed.inject.TypeLiteral;
import com.sekwah.advancedportals.shadowed.inject.internal.Annotations;
import com.sekwah.advancedportals.shadowed.inject.internal.DeclaredMembers;
import com.sekwah.advancedportals.shadowed.inject.internal.Errors;
import com.sekwah.advancedportals.shadowed.inject.internal.ProviderMethod;
import com.sekwah.advancedportals.shadowed.inject.internal.ProvidesMethodScanner;
import com.sekwah.advancedportals.shadowed.inject.spi.InjectionPoint;
import com.sekwah.advancedportals.shadowed.inject.spi.Message;
import com.sekwah.advancedportals.shadowed.inject.spi.ModuleAnnotatedMethodScanner;
import com.sekwah.advancedportals.shadowed.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ProviderMethodsModule
implements Module {
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;
    private final boolean skipFastClassGeneration;
    private final ModuleAnnotatedMethodScanner scanner;

    private ProviderMethodsModule(Object delegate, boolean skipFastClassGeneration, ModuleAnnotatedMethodScanner scanner) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.typeLiteral = TypeLiteral.get(this.getDelegateModuleClass());
        this.skipFastClassGeneration = skipFastClassGeneration;
        this.scanner = scanner;
    }

    public static Module forModule(Module module) {
        return ProviderMethodsModule.forObject(module, false, ProvidesMethodScanner.INSTANCE);
    }

    public static Module forModule(Object module, ModuleAnnotatedMethodScanner scanner) {
        return ProviderMethodsModule.forObject(module, false, scanner);
    }

    public static Module forObject(Object object) {
        return ProviderMethodsModule.forObject(object, true, ProvidesMethodScanner.INSTANCE);
    }

    private static Module forObject(Object object, boolean skipFastClassGeneration, ModuleAnnotatedMethodScanner scanner) {
        if (object instanceof ProviderMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new ProviderMethodsModule(object, skipFastClassGeneration, scanner);
    }

    public Class<?> getDelegateModuleClass() {
        return this.isStaticModule() ? (Class<?>)this.delegate : this.delegate.getClass();
    }

    private boolean isStaticModule() {
        return this.delegate instanceof Class;
    }

    @Override
    public void configure(Binder binder) {
        for (ProviderMethod<?> providerMethod : this.getProviderMethods(binder)) {
            providerMethod.configure(binder);
        }
    }

    public List<ProviderMethod<?>> getProviderMethods(Binder binder) {
        Class<?> superMostClass;
        ArrayList result = null;
        ArrayList<MethodAndAnnotation> methodsAndAnnotations = null;
        for (Class<?> c = superMostClass = this.getDelegateModuleClass(); c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : DeclaredMembers.getDeclaredMethods(c)) {
                ProviderMethod providerMethod;
                Annotation annotation = this.getAnnotation(binder, method);
                if (annotation == null) continue;
                if (this.isStaticModule() && !Modifier.isStatic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
                    binder.skipSources(ProviderMethodsModule.class).addError("%s is an instance method, but a class literal was passed. Make this method static or pass an instance of the module instead.", method);
                    continue;
                }
                if (result == null) {
                    result = new ArrayList();
                    methodsAndAnnotations = new ArrayList<MethodAndAnnotation>();
                }
                if ((providerMethod = this.createProviderMethod(binder, method, annotation)) != null) {
                    result.add(providerMethod);
                }
                methodsAndAnnotations.add(new MethodAndAnnotation(method, annotation));
                superMostClass = c;
            }
        }
        if (result == null) {
            return ImmutableList.of();
        }
        HashMultimap<Signature, Method> methodsBySignature = null;
        for (Class<?> c = this.getDelegateModuleClass(); c != superMostClass; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if ((method.getModifiers() & 0xA) != 0 || method.isBridge() || method.isSynthetic()) continue;
                if (methodsBySignature == null) {
                    methodsBySignature = HashMultimap.create();
                }
                methodsBySignature.put(new Signature(this.typeLiteral, method), method);
            }
        }
        if (methodsBySignature != null) {
            block4: for (MethodAndAnnotation methodAndAnnotation : methodsAndAnnotations) {
                Method method = methodAndAnnotation.method;
                Annotation annotation = methodAndAnnotation.annotation;
                for (Method matchingSignature : methodsBySignature.get(new Signature(this.typeLiteral, method))) {
                    String string;
                    if (matchingSignature.getDeclaringClass().isAssignableFrom(method.getDeclaringClass()) || !ProviderMethodsModule.overrides(matchingSignature, method)) continue;
                    if (annotation.annotationType() == Provides.class) {
                        string = "@Provides";
                    } else {
                        String string2 = String.valueOf(annotation.annotationType().getCanonicalName());
                        string = string2.length() != 0 ? "@".concat(string2) : new String("@");
                    }
                    String annotationString = string;
                    binder.addError(new StringBuilder(67 + String.valueOf(annotationString).length() + String.valueOf(annotationString).length()).append("Overriding ").append(annotationString).append(" methods is not allowed.\n\t").append(annotationString).append(" method: %s\n\toverridden by: %s").toString(), method, matchingSignature);
                    continue block4;
                }
            }
        }
        return result;
    }

    private Annotation getAnnotation(Binder binder, Method method) {
        if (method.isBridge() || method.isSynthetic()) {
            return null;
        }
        Annotation annotation = null;
        for (Class<? extends Annotation> clazz : this.scanner.annotationClasses()) {
            Annotation foundAnnotation = method.getAnnotation(clazz);
            if (foundAnnotation == null) continue;
            if (annotation != null) {
                binder.addError("More than one annotation claimed by %s on method %s. Methods can only have one annotation claimed per scanner.", this.scanner, method);
                return null;
            }
            annotation = foundAnnotation;
        }
        return annotation;
    }

    private static boolean overrides(Method a, Method b) {
        int modifiers = b.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        return a.getDeclaringClass().getPackage().equals(b.getDeclaringClass().getPackage());
    }

    private <T> ProviderMethod<T> createProviderMethod(Binder binder, Method method, Annotation annotation) {
        binder = binder.withSource(method);
        Errors errors = new Errors(method);
        InjectionPoint point = InjectionPoint.forMethod(method, this.typeLiteral);
        TypeLiteral<?> returnType = this.typeLiteral.getReturnType(method);
        Key<?> key = this.getKey(errors, returnType, method, method.getAnnotations());
        boolean prepareMethodError = false;
        try {
            key = this.scanner.prepareMethod(binder, annotation, key, point);
        }
        catch (Throwable t) {
            prepareMethodError = true;
            binder.addError(t);
        }
        if (Modifier.isAbstract(method.getModifiers())) {
            Preconditions.checkState(prepareMethodError || key == null, "%s returned a non-null key (%s) for %s. prepareMethod() must return null for abstract methods", (Object)this.scanner, key, (Object)method);
            return null;
        }
        if (key == null) {
            return null;
        }
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, method.getAnnotations());
        for (Message message : errors.getMessages()) {
            binder.addError(message);
        }
        return ProviderMethod.create(key, method, this.isStaticModule() || Modifier.isStatic(method.getModifiers()) ? null : this.delegate, ImmutableSet.copyOf(point.getDependencies()), scopeAnnotation, this.skipFastClassGeneration, annotation);
    }

    <T> Key<T> getKey(Errors errors, TypeLiteral<T> type, Member member, Annotation[] annotations) {
        Annotation bindingAnnotation = Annotations.findBindingAnnotation(errors, member, annotations);
        return bindingAnnotation == null ? Key.get(type) : Key.get(type, bindingAnnotation);
    }

    public boolean equals(Object o) {
        return o instanceof ProviderMethodsModule && ((ProviderMethodsModule)o).delegate == this.delegate && ((ProviderMethodsModule)o).scanner.equals(this.scanner);
    }

    public int hashCode() {
        return Objects.hashCode(this.delegate, this.scanner);
    }

    public boolean isScanningBuiltInProvidesMethods() {
        return this.scanner == ProvidesMethodScanner.INSTANCE;
    }

    public ModuleAnnotatedMethodScanner getScanner() {
        return this.scanner;
    }

    private static final class Signature {
        final Class<?>[] parameters;
        final String name;
        final int hashCode;

        Signature(TypeLiteral<?> typeLiteral, Method method) {
            this.name = method.getName();
            List<TypeLiteral<?>> resolvedParameterTypes = typeLiteral.getParameterTypes(method);
            this.parameters = new Class[resolvedParameterTypes.size()];
            int i = 0;
            for (TypeLiteral<?> type : resolvedParameterTypes) {
                this.parameters[i] = type.getRawType();
            }
            this.hashCode = this.name.hashCode() + 31 * Arrays.hashCode(this.parameters);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Signature) {
                Signature other = (Signature)obj;
                return other.name.equals(this.name) && Arrays.equals(this.parameters, other.parameters);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class MethodAndAnnotation {
        final Method method;
        final Annotation annotation;

        MethodAndAnnotation(Method method, Annotation annotation) {
            this.method = method;
            this.annotation = annotation;
        }
    }
}

