/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.inject.internal;

import com.sekwah.advancedportals.shadowed.guava.base.Objects;
import com.sekwah.advancedportals.shadowed.guava.base.Preconditions;
import com.sekwah.advancedportals.shadowed.guava.cache.Cache;
import com.sekwah.advancedportals.shadowed.guava.cache.CacheBuilder;
import com.sekwah.advancedportals.shadowed.guava.cache.RemovalCause;
import com.sekwah.advancedportals.shadowed.guava.cache.RemovalNotification;
import com.sekwah.advancedportals.shadowed.guava.collect.LinkedHashMultiset;
import com.sekwah.advancedportals.shadowed.guava.collect.Maps;
import com.sekwah.advancedportals.shadowed.guava.collect.Multiset;
import com.sekwah.advancedportals.shadowed.guava.collect.Sets;
import com.sekwah.advancedportals.shadowed.inject.Key;
import com.sekwah.advancedportals.shadowed.inject.internal.Errors;
import com.sekwah.advancedportals.shadowed.inject.internal.InjectorBindingData;
import com.sekwah.advancedportals.shadowed.inject.internal.util.SourceProvider;
import java.util.Map;
import java.util.Set;

final class WeakKeySet {
    private Map<Key<?>, Multiset<Object>> backingMap;
    private final Object lock;
    private final Cache<InjectorBindingData, Set<KeyAndSource>> evictionCache = CacheBuilder.newBuilder().weakKeys().removalListener(this::cleanupOnRemoval).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupOnRemoval(RemovalNotification<InjectorBindingData, Set<KeyAndSource>> notification) {
        Preconditions.checkState(RemovalCause.COLLECTED.equals((Object)notification.getCause()));
        Object object = this.lock;
        synchronized (object) {
            for (KeyAndSource keyAndSource : (Set)notification.getValue()) {
                Multiset<Object> set = this.backingMap.get(keyAndSource.key);
                if (set == null) continue;
                set.remove(keyAndSource.source);
                if (!set.isEmpty()) continue;
                this.backingMap.remove(keyAndSource.key);
            }
        }
    }

    WeakKeySet(Object lock) {
        this.lock = lock;
    }

    public void add(Key<?> key, InjectorBindingData state, Object source) {
        if (this.backingMap == null) {
            this.backingMap = Maps.newHashMap();
        }
        if (source instanceof Class || source == SourceProvider.UNKNOWN_SOURCE) {
            source = null;
        }
        Object convertedSource = Errors.convert(source);
        this.backingMap.computeIfAbsent(key, k -> LinkedHashMultiset.create()).add(convertedSource);
        if (state.parent().isPresent()) {
            Set<KeyAndSource> keyAndSources = this.evictionCache.getIfPresent(state);
            if (keyAndSources == null) {
                keyAndSources = Sets.newHashSet();
                this.evictionCache.put(state, keyAndSources);
            }
            keyAndSources.add(new KeyAndSource(key, convertedSource));
        }
    }

    public boolean contains(Key<?> key) {
        this.evictionCache.cleanUp();
        return this.backingMap != null && this.backingMap.containsKey(key);
    }

    public Set<Object> getSources(Key<?> key) {
        this.evictionCache.cleanUp();
        Multiset<Object> sources = this.backingMap == null ? null : this.backingMap.get(key);
        return sources == null ? null : sources.elementSet();
    }

    private static final class KeyAndSource {
        final Key<?> key;
        final Object source;

        KeyAndSource(Key<?> key, Object source) {
            this.key = key;
            this.source = source;
        }

        public int hashCode() {
            return Objects.hashCode(this.key, this.source);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KeyAndSource)) {
                return false;
            }
            KeyAndSource other = (KeyAndSource)obj;
            return Objects.equal(this.key, other.key) && Objects.equal(this.source, other.source);
        }
    }
}

