/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.inject.internal.aop;

import com.sekwah.advancedportals.shadowed.guava.cache.CacheBuilder;
import com.sekwah.advancedportals.shadowed.guava.cache.CacheLoader;
import com.sekwah.advancedportals.shadowed.guava.cache.LoadingCache;
import com.sekwah.advancedportals.shadowed.inject.internal.InternalFlags;
import com.sekwah.advancedportals.shadowed.inject.internal.aop.ClassDefiner;
import com.sekwah.advancedportals.shadowed.inject.internal.asm.$ClassWriter;
import com.sekwah.advancedportals.shadowed.inject.internal.asm.$MethodVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UnsafeClassDefiner
implements ClassDefiner {
    private static final Logger logger = Logger.getLogger(UnsafeClassDefiner.class.getName());
    private static final Object THE_UNSAFE = UnsafeClassDefiner.tryPrivileged(UnsafeClassDefiner::bindTheUnsafe, "Cannot bind the Unsafe instance");
    private static final Method ANONYMOUS_DEFINE_METHOD = UnsafeClassDefiner.tryPrivileged(UnsafeClassDefiner::bindAnonymousDefineMethod, "Cannot bind Unsafe.defineAnonymousClass");
    private static final boolean ALWAYS_DEFINE_ANONYMOUSLY = InternalFlags.getCustomClassLoadingOption() == InternalFlags.CustomClassLoadingOption.ANONYMOUS;
    private static final String DEFINEACCESS_BY_GUICE_MARKER = "$$DefineAccessByGuice$$";

    UnsafeClassDefiner() {
    }

    public static boolean isAccessible() {
        return ANONYMOUS_DEFINE_METHOD != null;
    }

    public static boolean isAnonymousHost(Class<?> hostClass) {
        return UnsafeClassDefiner.findDefineMethod(hostClass.getClassLoader()) == ANONYMOUS_DEFINE_METHOD;
    }

    @Override
    public Class<?> define(Class<?> hostClass, byte[] bytecode) throws Exception {
        ClassLoader hostLoader = hostClass.getClassLoader();
        Method defineMethod = UnsafeClassDefiner.findDefineMethod(hostLoader);
        if (defineMethod == ANONYMOUS_DEFINE_METHOD) {
            return UnsafeClassDefiner.defineAnonymously(hostClass, bytecode);
        }
        return (Class)defineMethod.invoke(null, hostLoader, bytecode);
    }

    private static Method findDefineMethod(ClassLoader hostLoader) {
        if (hostLoader == null || ALWAYS_DEFINE_ANONYMOUSLY) {
            return ANONYMOUS_DEFINE_METHOD;
        }
        if (ClassLoaderDefineMethodHolder.CLASS_LOADER_DEFINE_METHOD != null) {
            return ClassLoaderDefineMethodHolder.CLASS_LOADER_DEFINE_METHOD;
        }
        return DefineMethodCacheHolder.DEFINE_METHOD_CACHE.getUnchecked(hostLoader.getClass());
    }

    private static Class<?> defineAnonymously(Class<?> hostClass, byte[] bytecode) throws Exception {
        return (Class)ANONYMOUS_DEFINE_METHOD.invoke(THE_UNSAFE, hostClass, bytecode, null);
    }

    private static Object bindTheUnsafe() throws Exception {
        Class<?> unsafeType = Class.forName("sun.misc.Unsafe");
        Field theUnsafeField = unsafeType.getDeclaredField("theUnsafe");
        theUnsafeField.setAccessible(true);
        return theUnsafeField.get(null);
    }

    private static Method bindAnonymousDefineMethod() throws Exception {
        Class<?> unsafeType = THE_UNSAFE.getClass();
        return unsafeType.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
    }

    static <T> T tryPrivileged(PrivilegedExceptionAction<T> action, String errorMessage) {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (Throwable e) {
            logger.log(Level.FINE, errorMessage, e);
            return null;
        }
    }

    static Method tryAccessDefineMethod(Class<?> loaderClass) {
        try {
            logger.log(Level.FINE, "Accessing defineClass method in %s", loaderClass);
            return AccessController.doPrivileged(() -> UnsafeClassDefiner.accessDefineMethod(loaderClass));
        }
        catch (Throwable e) {
            String string = String.valueOf(loaderClass);
            logger.log(Level.FINE, new StringBuilder(36 + String.valueOf(string).length()).append("Cannot access defineClass method in ").append(string).toString(), e);
            return ANONYMOUS_DEFINE_METHOD;
        }
    }

    static Method accessDefineMethod(Class<?> loaderClass) throws Exception {
        byte[] bytecode = UnsafeClassDefiner.buildDefineClassAccess(loaderClass);
        Class<?> accessClass = UnsafeClassDefiner.defineAnonymously(loaderClass, bytecode);
        return accessClass.getMethod("defineClass", ClassLoader.class, byte[].class);
    }

    private static byte[] buildDefineClassAccess(Class<?> loaderClass) {
        $ClassWriter cw = new $ClassWriter(1);
        String string = String.valueOf(loaderClass.getName().replace('.', '/'));
        String string2 = String.valueOf(DEFINEACCESS_BY_GUICE_MARKER);
        cw.visit(52, 33, string2.length() != 0 ? string.concat(string2) : new String(string), null, "java/lang/Object", null);
        $MethodVisitor mv = cw.visitMethod(9, "defineClass", "(Ljava/lang/ClassLoader;[B)Ljava/lang/Class;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(190);
        mv.visitMethodInsn(182, "java/lang/ClassLoader", "defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static class DefineMethodCacheHolder {
        static final LoadingCache<Class<?>, Method> DEFINE_METHOD_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build(CacheLoader.from(UnsafeClassDefiner::tryAccessDefineMethod));

        private DefineMethodCacheHolder() {
        }
    }

    private static class ClassLoaderDefineMethodHolder {
        static final Method CLASS_LOADER_DEFINE_METHOD = UnsafeClassDefiner.tryPrivileged(() -> UnsafeClassDefiner.accessDefineMethod(ClassLoader.class), "Cannot access ClassLoader.defineClass");

        private ClassLoaderDefineMethodHolder() {
        }
    }
}

