/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.shadowed.inject.spi;

import com.sekwah.advancedportals.shadowed.guava.base.Objects;
import com.sekwah.advancedportals.shadowed.guava.base.Preconditions;
import com.sekwah.advancedportals.shadowed.inject.Binder;
import com.sekwah.advancedportals.shadowed.inject.ConfigurationException;
import com.sekwah.advancedportals.shadowed.inject.spi.Element;
import com.sekwah.advancedportals.shadowed.inject.spi.ElementVisitor;
import com.sekwah.advancedportals.shadowed.inject.spi.InjectionPoint;
import java.util.Set;

public final class StaticInjectionRequest
implements Element {
    private final Object source;
    private final Class<?> type;

    StaticInjectionRequest(Object source, Class<?> type) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.type = Preconditions.checkNotNull(type, "type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forStaticMethodsAndFields(this.type);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestStaticInjection(this.type);
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof StaticInjectionRequest && ((StaticInjectionRequest)obj).source.equals(this.source) && ((StaticInjectionRequest)obj).type.equals(this.type);
    }

    public int hashCode() {
        return Objects.hashCode(this.source, this.type);
    }
}

