/*
 * Decompiled with CFR 0.152.
 */
package com.launcher.listeners;

import com.launcher.Main;
import com.launcher.menus.AdminMainMenu;
import com.launcher.menus.BanMenu;
import com.launcher.menus.ChatControlMenu;
import com.launcher.menus.GamemodeMenu;
import com.launcher.menus.KickMenu;
import com.launcher.menus.ServerManagementMenu;
import com.launcher.menus.TeleportMenu;
import com.launcher.menus.TimeControlMenu;
import com.launcher.menus.WeatherControlMenu;
import com.launcher.utils.GuiUtils;
import java.util.Date;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuClickListener
implements Listener {
    @EventHandler
    public void onMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a74\u00a7lAdmin Menu \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                switch (event.getSlot()) {
                    case 20: {
                        BanMenu.openMenu(player);
                        break;
                    }
                    case 29: {
                        KickMenu.openMenu(player);
                        break;
                    }
                    case 38: {
                        TeleportMenu.openMenu(player);
                        break;
                    }
                    case 22: {
                        ServerManagementMenu.openMenu(player);
                        break;
                    }
                    case 31: {
                        GamemodeMenu.openMenu(player);
                        break;
                    }
                    case 24: {
                        TimeControlMenu.openMenu(player);
                        break;
                    }
                    case 33: {
                        WeatherControlMenu.openMenu(player);
                        break;
                    }
                    case 42: {
                        ChatControlMenu.openMenu(player);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onGamemodeMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a7a\u00a7lGamemode Manager \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                switch (event.getSlot()) {
                    case 21: {
                        player.setGameMode(GameMode.CREATIVE);
                        player.sendMessage(Main.getInstance().getMessage("menu.gamemode-changed").replace("%gamemode%", "Creative"));
                        player.closeInventory();
                        break;
                    }
                    case 23: {
                        player.setGameMode(GameMode.SURVIVAL);
                        player.sendMessage(Main.getInstance().getMessage("menu.gamemode-changed").replace("%gamemode%", "Survival"));
                        player.closeInventory();
                        break;
                    }
                    case 25: {
                        player.setGameMode(GameMode.SPECTATOR);
                        player.sendMessage(Main.getInstance().getMessage("menu.gamemode-changed").replace("%gamemode%", "Spectator"));
                        player.closeInventory();
                        break;
                    }
                    case 31: {
                        player.setGameMode(GameMode.ADVENTURE);
                        player.sendMessage(Main.getInstance().getMessage("menu.gamemode-changed").replace("%gamemode%", "Adventure"));
                        player.closeInventory();
                        break;
                    }
                    case 49: {
                        AdminMainMenu.openMenu(player);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onServerManagementMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a7b\u00a7lServer Management \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                switch (event.getSlot()) {
                    case 22: {
                        Bukkit.broadcastMessage((String)"\u00a7c\u00a7lServer restarting in 10 seconds!");
                        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"restart"), 200L);
                        player.closeInventory();
                        break;
                    }
                    case 31: {
                        Bukkit.broadcastMessage((String)"\u00a76\u00a7lServer reloading...");
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"reload");
                        player.closeInventory();
                        break;
                    }
                    case 40: {
                        Bukkit.broadcastMessage((String)"\u00a7c\u00a7lServer shutting down in 5 seconds!");
                        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"stop"), 100L);
                        player.closeInventory();
                        break;
                    }
                    case 49: {
                        AdminMainMenu.openMenu(player);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onKickMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a7e\u00a7lKick Players \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                if (event.getSlot() == 49) {
                    AdminMainMenu.openMenu(player);
                } else {
                    ItemStack clicked = event.getCurrentItem();
                    if (clicked != null && clicked.getType() == Material.PLAYER_HEAD) {
                        String targetName = clicked.getItemMeta().getDisplayName().replace("\u00a7e\u00a7l", "");
                        Player target = Bukkit.getPlayer((String)targetName);
                        if (target != null) {
                            target.kickPlayer("\u00a7c\u00a7lYou have been kicked by an administrator");
                            player.sendMessage(Main.getInstance().getMessage("menu.kick-success").replace("%player%", targetName));
                        }
                        player.closeInventory();
                    }
                }
            }
        }
    }

    @EventHandler
    public void onBanMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a74\u00a7lBan Players \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                ItemStack clicked = event.getCurrentItem();
                if (clicked != null) {
                    String targetName;
                    Player target;
                    if (event.getSlot() == 49) {
                        AdminMainMenu.openMenu(player);
                    } else if (clicked.getType() == Material.PLAYER_HEAD && clicked.hasItemMeta() && (target = Bukkit.getPlayer((String)(targetName = clicked.getItemMeta().getDisplayName().replace("\u00a7c\u00a7l", "")))) != null) {
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(targetName, "\u00a7c\u00a7lBanned by an administrator", (Date)null, player.getName());
                        target.kickPlayer("\u00a7c\u00a7lYou have been banned from the server!");
                        player.sendMessage(Main.getInstance().getMessage("menu.ban-success").replace("%player%", targetName));
                        player.closeInventory();
                    }
                }
            }
        }
    }

    @EventHandler
    public void onTimeControlMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a7e\u00a7lTime Control \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                switch (event.getSlot()) {
                    case 20: {
                        player.getWorld().setTime(1000L);
                        GuiUtils.playSuccessSound(player);
                        player.sendMessage("\u00a7e\u00a7lTime set to: \u00a7fDay (6:00)");
                        player.closeInventory();
                        break;
                    }
                    case 22: {
                        player.getWorld().setTime(6000L);
                        player.sendMessage("\u00a76\u00a7lTime set to: \u00a7fNoon (12:00)");
                        player.closeInventory();
                        break;
                    }
                    case 24: {
                        player.getWorld().setTime(12000L);
                        player.sendMessage("\u00a7c\u00a7lTime set to: \u00a7fSunset (18:00)");
                        player.closeInventory();
                        break;
                    }
                    case 31: {
                        player.getWorld().setTime(18000L);
                        player.sendMessage("\u00a79\u00a7lTime set to: \u00a7fNight (0:00)");
                        player.closeInventory();
                        break;
                    }
                    case 49: {
                        AdminMainMenu.openMenu(player);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onWeatherControlMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a7b\u00a7lWeather Control \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                switch (event.getSlot()) {
                    case 22: {
                        player.getWorld().setStorm(false);
                        player.getWorld().setThundering(false);
                        player.sendMessage("\u00a7e\u00a7lWeather set to: \u00a7fSunny");
                        player.closeInventory();
                        break;
                    }
                    case 31: {
                        player.getWorld().setStorm(true);
                        player.getWorld().setThundering(false);
                        player.sendMessage("\u00a79\u00a7lWeather set to: \u00a7fRain");
                        player.closeInventory();
                        break;
                    }
                    case 40: {
                        player.getWorld().setStorm(true);
                        player.getWorld().setThundering(true);
                        player.sendMessage("\u00a7c\u00a7lWeather set to: \u00a7fThunderstorm");
                        player.closeInventory();
                        break;
                    }
                    case 49: {
                        AdminMainMenu.openMenu(player);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onChatControlMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a7a\u00a7lChat Control \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                switch (event.getSlot()) {
                    case 22: {
                        Main.isChatEnabled = true;
                        Bukkit.broadcastMessage((String)Main.getInstance().getMessage("menu.chat-enabled"));
                        player.closeInventory();
                        break;
                    }
                    case 31: {
                        Main.isChatEnabled = false;
                        Bukkit.broadcastMessage((String)Main.getInstance().getMessage("menu.chat-disabled"));
                        player.closeInventory();
                        break;
                    }
                    case 40: {
                        for (int i = 0; i < 100; ++i) {
                            Bukkit.broadcastMessage((String)"");
                        }
                        Bukkit.broadcastMessage((String)Main.getInstance().getMessage("menu.chat-cleared").replace("%player%", player.getName()));
                        player.closeInventory();
                        break;
                    }
                    case 49: {
                        AdminMainMenu.openMenu(player);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onTeleportMenuClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("\u00a78\u00bb \u00a75\u00a7lTeleport Menu \u00a78\u00ab")) {
            event.setCancelled(true);
            if (event.getWhoClicked() instanceof Player) {
                Player player = (Player)event.getWhoClicked();
                ItemStack clicked = event.getCurrentItem();
                if (clicked != null) {
                    String targetName;
                    Player target;
                    if (event.getSlot() == 49) {
                        AdminMainMenu.openMenu(player);
                    } else if (clicked.getType() == Material.PLAYER_HEAD && clicked.hasItemMeta() && (target = Bukkit.getPlayer((String)(targetName = clicked.getItemMeta().getDisplayName().replace("\u00a75\u00a7l", "")))) != null) {
                        player.teleport(target.getLocation());
                        player.sendMessage(Main.getInstance().getMessage("menu.teleport-success").replace("%player%", targetName));
                        player.closeInventory();
                    }
                }
            }
        }
    }
}

