/*
 * Decompiled with CFR 0.152.
 */
package com.launcher.utils;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GuiUtils {
    private static final Material BORDER_MATERIAL = Material.BLACK_STAINED_GLASS_PANE;
    private static final Material CORNER_MATERIAL = Material.GRAY_STAINED_GLASS_PANE;
    private static final Material SEPARATOR_MATERIAL = Material.LIGHT_BLUE_STAINED_GLASS_PANE;

    public static Inventory createStandardMenu(String title) {
        int i;
        Inventory menu = Bukkit.createInventory(null, (int)54, (String)title);
        for (i = 0; i < 9; ++i) {
            menu.setItem(i, GuiUtils.createItem(BORDER_MATERIAL, " ", new String[0]));
            menu.setItem(45 + i, GuiUtils.createItem(BORDER_MATERIAL, " ", new String[0]));
        }
        for (i = 9; i < 45; i += 9) {
            menu.setItem(i, GuiUtils.createItem(BORDER_MATERIAL, " ", new String[0]));
            menu.setItem(i + 8, GuiUtils.createItem(BORDER_MATERIAL, " ", new String[0]));
        }
        menu.setItem(0, GuiUtils.createItem(CORNER_MATERIAL, " ", new String[0]));
        menu.setItem(8, GuiUtils.createItem(CORNER_MATERIAL, " ", new String[0]));
        menu.setItem(45, GuiUtils.createItem(CORNER_MATERIAL, " ", new String[0]));
        menu.setItem(53, GuiUtils.createItem(CORNER_MATERIAL, " ", new String[0]));
        return menu;
    }

    public static ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        if (lore.length > 0) {
            meta.setLore(Arrays.asList(lore));
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_POTION_EFFECTS});
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createGlowingItem(Material material, String name, String ... lore) {
        ItemStack item = GuiUtils.createItem(material, name, lore);
        ItemMeta meta = item.getItemMeta();
        meta.addEnchant(Enchantment.DURABILITY, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createPlayerHead(Player player, String nameColor, String ... lore) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer((OfflinePlayer)player);
        meta.setDisplayName(nameColor + player.getName());
        if (lore.length > 0) {
            meta.setLore(Arrays.asList(lore));
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public static ItemStack createBackButton() {
        return GuiUtils.createItem(Material.ARROW, "\u00a7c\u00ab Back", "Click to return to main menu");
    }

    public static void addMenuSeparator(Inventory menu, int startSlot, int endSlot) {
        for (int i = startSlot; i <= endSlot; ++i) {
            menu.setItem(i, GuiUtils.createItem(SEPARATOR_MATERIAL, " ", new String[0]));
        }
    }

    public static void playSuccessSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
    }

    public static void playErrorSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
    }

    public static void playClickSound(Player player) {
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
    }
}

