/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.config.configs.GeneralConfig;
import net.azureaaron.mod.utils.OkLabColour;
import net.minecraft.class_3532;

public class Colour {
    private static final Supplier<GeneralConfig.CustomColourProfile> CUSTOM = () -> AaronModConfigManager.get().general.customColourProfile;
    public static final int WARNING = 15386724;
    public static final int INFO = 2198527;

    public static int interpolate(int firstColour, int secondColour, double percentage) {
        int r1 = class_3532.method_34954((int)(firstColour >> 16 & 0xFF));
        int g1 = class_3532.method_34954((int)(firstColour >> 8 & 0xFF));
        int b1 = class_3532.method_34954((int)(firstColour & 0xFF));
        int r2 = class_3532.method_34954((int)(secondColour >> 16 & 0xFF));
        int g2 = class_3532.method_34954((int)(secondColour >> 8 & 0xFF));
        int b2 = class_3532.method_34954((int)(secondColour & 0xFF));
        double inverse = 1.0 - percentage;
        int r3 = (int)Math.floor(Math.sqrt((double)r1 * inverse + (double)r2 * percentage));
        int g3 = (int)Math.floor(Math.sqrt((double)g1 * inverse + (double)g2 * percentage));
        int b3 = (int)Math.floor(Math.sqrt((double)b1 * inverse + (double)b2 * percentage));
        return r3 << 16 | g3 << 8 | b3;
    }

    public static enum ColourProfiles {
        Original(14762514, 15385935, 16486212, 16401737, 13686750, 9213343),
        Midnight(6699450, 348334, 10778105, 15385935, 13686750, 9213343),
        Earth(1736503, 616922, 4899435, 7687491, 13686750, 9213343),
        Sakura(12532105, 13574702, 16744648, 16185594, 13686750, 9213343),
        Cloudy(7239553, 15396594, 9213343, 2369839, 13686750, 4344403),
        Halloween(14964224, 5726314, 8951461, 13752287, 15396594, 9213343),
        Christmas(13574702, 1139497, 16185594, 16401737, 13686750, 9213343),
        Candyland(0xFFB3B3, 16772235, 10082794, 0xF08080, 16770273, 12763888),
        Cyberpunk(31743, 52937, 2664261, 0xFF9933, 3422784, 0xEAECEE),
        Lava(0xFF0000, 0xFF9933, 16766720, 15787660, 0x696969, 0xF5F5F5),
        Ocean(31743, 3447003, 0x474747, 2664261, 12763888, 0xE0E0E0),
        Custom(() -> Colour.CUSTOM.get().primaryColour.getRGB(), () -> Colour.CUSTOM.get().secondaryColour.getRGB(), () -> Colour.CUSTOM.get().infoColour.getRGB(), () -> Colour.CUSTOM.get().highlightColour.getRGB(), () -> Colour.CUSTOM.get().hoverColour.getRGB(), () -> Colour.CUSTOM.get().supportingInfoColour.getRGB());

        public final IntSupplier primaryColour;
        public final IntSupplier secondaryColour;
        public final IntSupplier infoColour;
        public final IntSupplier highlightColour;
        public final IntSupplier hoverColour;
        public final IntSupplier supportingInfoColour;

        private ColourProfiles(int primaryColour, int secondaryColour, int infoColour, int highlightColour, int hoverColour, int supportingInfoColour) {
            this(() -> primaryColour, () -> secondaryColour, () -> infoColour, () -> highlightColour, () -> hoverColour, () -> supportingInfoColour);
        }

        private ColourProfiles(IntSupplier primaryColour, IntSupplier secondaryColour, IntSupplier infoColour, IntSupplier highlightColour, IntSupplier hoverColour, IntSupplier supportingInfoColour) {
            this.primaryColour = primaryColour;
            this.secondaryColour = secondaryColour;
            this.infoColour = infoColour;
            this.highlightColour = highlightColour;
            this.hoverColour = hoverColour;
            this.supportingInfoColour = supportingInfoColour;
        }

        public int gradient(double percentage) {
            return OkLabColour.interpolate(this.primaryColour.getAsInt(), this.secondaryColour.getAsInt(), (float)percentage);
        }
    }
}

