/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.azureaaron.dandelion.systems.Option;
import net.azureaaron.dandelion.systems.OptionGroup;
import net.azureaaron.dandelion.systems.controllers.Controller;
import net.azureaaron.dandelion.systems.controllers.FloatController;
import net.azureaaron.mod.Main;
import net.azureaaron.mod.config.AaronModConfig;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.config.ConfigUtils;
import net.azureaaron.mod.mixins.accessors.BillboardParticleAccessor;
import net.azureaaron.mod.utils.Functions;
import net.minecraft.class_156;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3940;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_703;
import net.minecraft.class_7923;

public class Particles {
    private static final Reference2ObjectOpenHashMap<class_2396<?>, String> PARTICLE_DESCRIPTIONS = (Reference2ObjectOpenHashMap)class_156.method_654((Object)new Reference2ObjectOpenHashMap(), descriptions -> {
        descriptions.put((Object)class_2398.field_22247, (Object)"Ash particles naturally generate in soul sand valleys.");
        descriptions.put((Object)class_2398.field_35434, (Object)"Block Marker particles are the particles you see for the light and barrier blocks for example.");
        descriptions.put((Object)class_2398.field_43379, (Object)"The leaves that fall from cherry trees.");
        descriptions.put((Object)class_2398.field_11205, (Object)"These particles can be seen when a critical hit is dealt against an enemy.");
        descriptions.put((Object)class_2398.field_11212, (Object)"Dust particles can come in any colour! One example of their usage is the dust emitted by redstone torches.");
        descriptions.put((Object)class_2398.field_11226, (Object)"The particles seen when an entity has an active potion effect.");
        descriptions.put((Object)class_2398.field_11208, (Object)"Enchanted Hit particles can be seen when dealing damage with a weapon thats enchanted.");
        descriptions.put((Object)class_2398.field_17909, (Object)"Flash particles are the flash of colour you see in the air when a firework explodes.");
        descriptions.put((Object)class_2398.field_11203, (Object)"The particles that appear after entity deaths.");
        descriptions.put((Object)class_2398.field_11242, (Object)"The small splashes of water you see on the ground when it rains.");
        descriptions.put((Object)class_2398.field_11228, (Object)"Don't let the llamas disrespect you.");
        descriptions.put((Object)class_2398.field_28803, (Object)"The particles that float around in the air near spore blossoms.");
        descriptions.put((Object)class_2398.field_28802, (Object)"The particles that fall down beneath spore blossoms.");
        descriptions.put((Object)class_2398.field_23956, (Object)"White Ash can be frequently found in the Basalt Deltas!");
    });

    public static class_703 modifyParticle(class_703 particle, class_2960 id) {
        class_3940 billboard;
        float alpha = AaronModConfigManager.get().particles.alphas.getOrDefault((Object)id, 1.0f);
        float scale = AaronModConfigManager.get().particles.scaling.getOrDefault((Object)id, 1.0f);
        if (particle instanceof class_3940 && (billboard = (class_3940)particle) instanceof BillboardParticleAccessor) {
            BillboardParticleAccessor accessor = (BillboardParticleAccessor)billboard;
            if (alpha > 0.1f && alpha < accessor.getAlpha()) {
                accessor.invokeSetAlpha(alpha);
                billboard.markHasCustomAlpha();
            }
        }
        return scale != 1.0f ? particle.method_3087(scale) : particle;
    }

    private static String getParticleDisplayName(String id) {
        return Functions.titleCase(id.toString().replace("_", " "));
    }

    public static List<OptionGroup> getOptionGroups(AaronModConfig config) {
        ArrayList<OptionGroup> list = new ArrayList<OptionGroup>();
        ArrayList entryList = new ArrayList(class_7923.field_41180.method_29722());
        entryList.sort((o1, o2) -> {
            String o1Name = Particles.getParticleDisplayName(((class_5321)o1.getKey()).method_29177().toString());
            String o2Name = Particles.getParticleDisplayName(((class_5321)o2.getKey()).method_29177().toString());
            return o1Name.compareTo(o2Name);
        });
        for (Map.Entry entry : entryList) {
            class_2396 particleType = (class_2396)entry.getValue();
            class_2960 id = ((class_5321)entry.getKey()).method_29177();
            String name = Particles.getParticleDisplayName(id.method_12832());
            String namespaceName = Particles.getParticleDisplayName(id.method_12836());
            class_5250 description = PARTICLE_DESCRIPTIONS.containsKey((Object)particleType) ? class_2561.method_43470((String)((String)PARTICLE_DESCRIPTIONS.get((Object)particleType))) : class_2561.method_43473();
            list.add(OptionGroup.createBuilder().name((class_2561)class_2561.method_43470((String)(name + " Particles (" + namespaceName + ")"))).description(new class_2561[]{description}).collapsed(true).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)("Enable " + name))).binding((Object)true, () -> config.particles.states.getOrDefault((Object)id, true), newValue -> config.particles.states.put((Object)id, newValue.booleanValue())).modifiable(!Main.OPTIFABRIC_LOADED).controller((Controller)ConfigUtils.createBooleanController()).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)(name + " Scale Multiplier"))).binding((Object)Float.valueOf(1.0f), () -> Float.valueOf(config.particles.scaling.getOrDefault((Object)id, 1.0f)), newValue -> config.particles.scaling.put((Object)id, newValue.floatValue())).modifiable(!Main.OPTIFABRIC_LOADED).controller(FloatController.createBuilder().range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(20.0f)).build()).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)(name + " Opacity"))).binding((Object)Float.valueOf(1.0f), () -> Float.valueOf(config.particles.alphas.getOrDefault((Object)id, 1.0f)), newValue -> config.particles.alphas.put((Object)id, newValue.floatValue())).controller(FloatController.createBuilder().range((Number)Float.valueOf(0.15f), (Number)Float.valueOf(1.0f)).slider((Number)Float.valueOf(0.05f)).build()).modifiable(!Main.OPTIFABRIC_LOADED).build()).build());
        }
        return list;
    }
}

