/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.util.UndashedUuid;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.azureaaron.mod.commands.CommandPlayerData;
import net.azureaaron.mod.commands.SkyblockCommand;
import net.azureaaron.mod.commands.VanillaCommand;
import net.azureaaron.mod.features.TextReplacer;
import net.azureaaron.mod.utils.ApiUtils;
import net.azureaaron.mod.utils.Functions;
import net.azureaaron.mod.utils.Http;
import net.azureaaron.mod.utils.Messages;
import net.azureaaron.mod.utils.Skyblock;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_327;
import org.slf4j.Logger;

public class CommandSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Supplier<class_327> TEXT_RENDERER = () -> class_310.method_1551().field_1772;

    public static String[] getPlayerSuggestions(FabricClientCommandSource source) {
        return (String[])source.method_9262().stream().filter(playerName -> playerName.matches("[A-Za-z0-9_]+")).toArray(String[]::new);
    }

    public static String getEndSpaces(class_2561 text) {
        class_327 textRenderer = TEXT_RENDERER.get();
        int spaceWidth = textRenderer.method_1727(" ");
        int textWidth = textRenderer.method_30880(TextReplacer.visuallyReplaceText(text.method_30937()));
        int spacesNeeded = (int)Math.ceil((double)textWidth / (double)spaceWidth);
        Object spaces = "";
        for (int i = 0; i < spacesNeeded; ++i) {
            spaces = (String)spaces + " ";
        }
        return spaces;
    }

    public static int handleSelf4Skyblock(SkyblockCommand command, FabricClientCommandSource source) {
        class_320 session = source.getClient().method_1548();
        return CommandSystem.handleSkyblockCommand(command, source, new CommandPlayerData(session.method_1676(), session.method_44717().toString().replaceAll("-", "")));
    }

    public static int handlePlayer4Skyblock(SkyblockCommand command, FabricClientCommandSource source, String player) {
        CompletableFuture.supplyAsync(() -> {
            try {
                return CommandSystem.lookupPlayer(player);
            }
            catch (Throwable t) {
                if (!Functions.isUuid(player)) {
                    source.sendError((class_2561)Messages.NAME_TO_UUID_ERROR.get());
                } else {
                    source.sendError((class_2561)Messages.UUID_TO_NAME_ERROR.get());
                }
                LOGGER.error("[Aaron's Mod] Encountered an exception while resolving a player's uuid/username!", t);
                return null;
            }
        }).thenAccept(playerData -> {
            if (playerData != null) {
                CommandSystem.handleSkyblockCommand(command, source, playerData);
            }
        });
        return 1;
    }

    private static int handleSkyblockCommand(SkyblockCommand command, FabricClientCommandSource source, CommandPlayerData playerData) {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return Http.sendHypixelRequest("skyblock/profiles", "?uuid=" + playerData.id());
            }
            catch (Throwable t) {
                source.sendError((class_2561)Messages.SKYBLOCK_PROFILES_FETCH_ERROR.get());
                LOGGER.error("[Aaron's Mod] Encountered an exception while fetching a player's skyblock profiles!", t);
                return null;
            }
        }).thenApply(body -> {
            try {
                return Skyblock.getSelectedProfile2(body);
            }
            catch (Throwable t) {
                if (t instanceof IllegalStateException) {
                    source.sendError((class_2561)Messages.NO_SKYBLOCK_PROFILES_ERROR.get());
                } else {
                    source.sendError((class_2561)Messages.JSON_PARSING_ERROR.get());
                }
                LOGGER.error("[Aaron's Mod] Encountered an exception while determining a player's selected skyblock profile!", t);
                return null;
            }
        })).thenAccept(profileData -> {
            if (profileData != null) {
                try {
                    command.print(source, (JsonObject)profileData, playerData.name(), playerData.id());
                }
                catch (Throwable t) {
                    source.sendError((class_2561)Messages.UNKNOWN_ERROR.get());
                    LOGGER.error("[Aaron's Mod] Encountered an exception while dispatching a skyblock command! Command: {}", (Object)command.getClass().getName(), (Object)t);
                }
            }
        });
        return 1;
    }

    public static int handleSelf4Vanilla(VanillaCommand command, FabricClientCommandSource source) {
        class_320 session = source.getClient().method_1548();
        try {
            command.print(source, session.method_1676(), session.method_44717().toString().replaceAll("-", ""));
        }
        catch (Throwable t) {
            source.sendError((class_2561)Messages.UNKNOWN_ERROR.get());
            LOGGER.error("[Aaron's Mod] Encountered an exception while dispatching a vanilla command! Command: {}", (Object)command.getClass().getName(), (Object)t);
        }
        return 1;
    }

    public static int handlePlayer4Vanilla(VanillaCommand command, FabricClientCommandSource source, String player) {
        CompletableFuture.supplyAsync(() -> {
            try {
                return CommandSystem.lookupPlayer(player);
            }
            catch (Throwable t) {
                if (!Functions.isUuid(player)) {
                    source.sendError((class_2561)Messages.NAME_TO_UUID_ERROR.get());
                } else {
                    source.sendError((class_2561)Messages.UUID_TO_NAME_ERROR.get());
                }
                LOGGER.error("[Aaron's Mod] Encountered an exception while resolving a player's uuid/username!", t);
                return null;
            }
        }).thenAccept(playerData -> {
            if (playerData != null) {
                try {
                    command.print(source, playerData.name(), playerData.id());
                }
                catch (Throwable t) {
                    source.sendError((class_2561)Messages.UNKNOWN_ERROR.get());
                    LOGGER.error("[Aaron's Mod] Encountered an exception while dispatching a vanilla command! Command: {}", (Object)command.getClass().getName(), (Object)t);
                }
            }
        });
        return 1;
    }

    private static CommandPlayerData lookupPlayer(String player) throws Exception {
        GameProfile profile = ApiUtils.getProfile(player);
        if (profile != null) {
            return new CommandPlayerData(profile.name(), UndashedUuid.toString((UUID)profile.id()));
        }
        throw new IllegalStateException("Failed to fetch the GameProfile for " + player);
    }
}

