/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.debug.Debug;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.UnsafeAccess;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class ReflectCommand
implements UnsafeAccess {
    private static final Supplier<class_5250> INVALID_OPCODE = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"Invalid Opcode!").method_27692(class_124.field_1061));
    private static final Supplier<class_5250> INVALID_TYPE = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"Invalid Type!").method_27692(class_124.field_1061));
    private static final Supplier<class_5250> TYPE_MISMATCH = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"Type Mismatch!").method_27692(class_124.field_1061));
    private static final Supplier<class_5250> TYPE_MISSING = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"Missing 'type' parameter!").method_27692(class_124.field_1061));
    private static final List<String> OPCODES = Arrays.asList("GETFIELD", "PUTFIELD");
    private static final List<String> TYPES = Arrays.asList("byte", "char", "double", "float", "int", "long", "short", "boolean", "string");

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(ReflectCommand::register);
    }

    private static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        if (Debug.debugEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reflect").then(ClientCommandManager.argument((String)"opcode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(OPCODES, (SuggestionsBuilder)builder)).then(ClientCommandManager.argument((String)"target class", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"target field", (ArgumentType)StringArgumentType.word()).executes(context -> ReflectCommand.reflectionExecutor((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"opcode"), StringArgumentType.getString((CommandContext)context, (String)"target class"), StringArgumentType.getString((CommandContext)context, (String)"target field"), null, null))).then(ClientCommandManager.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(TYPES, (SuggestionsBuilder)builder)).then(ClientCommandManager.argument((String)"new value", (ArgumentType)StringArgumentType.string()).executes(context -> ReflectCommand.reflectionExecutor((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"opcode"), StringArgumentType.getString((CommandContext)context, (String)"target class"), StringArgumentType.getString((CommandContext)context, (String)"target field"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"new value")))))))));
        }
    }

    private static int reflectionExecutor(FabricClientCommandSource source, String opcode, String targetClass, String target, String type, String newValue) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        if (!OPCODES.contains(opcode)) {
            source.sendError((class_2561)INVALID_OPCODE.get());
            return 1;
        }
        if (type != null && !TYPES.contains(type)) {
            source.sendError((class_2561)INVALID_TYPE.get());
            return 1;
        }
        try {
            Field field;
            Class<?> cls;
            Class<?> classObject = cls = Class.forName(targetClass);
            if (opcode.equals("GETFIELD")) {
                field = cls.getDeclaredField(target);
                field.setAccessible(true);
                String fieldValue = field.get(null).toString();
                source.sendFeedback((class_2561)class_2561.method_43470((String)"Field Get \u00bb ").method_54663(colourProfile.primaryColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)("[" + field.getType().getName() + "] " + field.getName() + ": ")).method_54663(colourProfile.secondaryColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)fieldValue).method_54663(colourProfile.infoColour.getAsInt()))));
            }
            if (opcode.equals("PUTFIELD")) {
                long offset;
                if (type == null) {
                    source.sendError((class_2561)TYPE_MISSING.get());
                    return 1;
                }
                field = cls.getDeclaredField(target);
                field.setAccessible(true);
                long l = offset = Modifier.isStatic(field.getModifiers()) ? UNSAFE.staticFieldOffset(field) : UNSAFE.objectFieldOffset(field);
                if (!field.getType().getName().equals(type.replace("string", "java.lang.String"))) {
                    source.sendError((class_2561)TYPE_MISMATCH.get());
                    return 1;
                }
                switch (type) {
                    case "byte": {
                        UNSAFE.putByte(classObject, offset, Byte.parseByte(newValue));
                        break;
                    }
                    case "char": {
                        UNSAFE.putChar(classObject, offset, newValue.charAt(0));
                        break;
                    }
                    case "double": {
                        UNSAFE.putDouble(classObject, offset, Double.parseDouble(newValue));
                        break;
                    }
                    case "float": {
                        UNSAFE.putFloat(classObject, offset, Float.parseFloat(newValue));
                        break;
                    }
                    case "int": {
                        UNSAFE.putInt(classObject, offset, Integer.parseInt(newValue));
                        break;
                    }
                    case "long": {
                        UNSAFE.putLong(classObject, offset, Long.parseLong(newValue));
                        break;
                    }
                    case "short": {
                        UNSAFE.putShort(classObject, offset, Short.parseShort(newValue));
                        break;
                    }
                    case "boolean": {
                        UNSAFE.putBoolean(classObject, offset, Boolean.parseBoolean(newValue));
                        break;
                    }
                    case "string": {
                        UNSAFE.putObject(classObject, offset, newValue);
                        break;
                    }
                    default: {
                        source.sendError((class_2561)class_2561.method_43470((String)"Field uses an unsupported type!"));
                        return 1;
                    }
                }
                String fieldValue = field.get(null).toString();
                source.sendFeedback((class_2561)class_2561.method_43470((String)"Field Set \u00bb ").method_54663(colourProfile.primaryColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)("[" + field.getType().getName() + "] " + field.getName() + ": ")).method_54663(colourProfile.secondaryColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)fieldValue).method_54663(colourProfile.infoColour.getAsInt()))));
            }
        }
        catch (ReflectiveOperationException e) {
            ReflectiveOperationException reflectiveOperationException = e;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassNotFoundException.class, NoSuchFieldException.class}, (Object)reflectiveOperationException, n)) {
                case 0: {
                    ClassNotFoundException ex = (ClassNotFoundException)reflectiveOperationException;
                    source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"The requested class wasn't found!").method_27692(class_124.field_1061)));
                    break;
                }
                case 1: {
                    NoSuchFieldException ex = (NoSuchFieldException)reflectiveOperationException;
                    source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"The requested field wasn't found!").method_27692(class_124.field_1061)));
                    break;
                }
            }
            e.printStackTrace();
        }
        return 1;
    }
}

