/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.ClientTextArgumentType;
import net.azureaaron.mod.features.TextReplacer;
import net.azureaaron.mod.screens.TextReplacerConfigScreen;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7157;

public class TextReplacerCommand {
    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(TextReplacerCommand::register);
    }

    private static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"textreplacer").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"replacementText", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"textComponent", (ArgumentType)ClientTextArgumentType.text()).executes(context -> TextReplacerCommand.addReplacement((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"replacementText"), (class_2561)context.getArgument("textComponent", class_2561.class))))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"replacementText", (ArgumentType)StringArgumentType.string()).suggests((commandSource, builder) -> class_2172.method_9265(TextReplacer.getTextReplacements(), (SuggestionsBuilder)builder)).executes(context -> TextReplacerCommand.removeReplacement((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"replacementText"))))));
    }

    private static int openTextReplacerConfig(FabricClientCommandSource source) {
        class_310 client = source.getClient();
        client.method_63588(() -> client.method_1507((class_437)new TextReplacerConfigScreen(null)));
        return 1;
    }

    private static int addReplacement(FabricClientCommandSource source, String replacementText, class_2561 textComponent) {
        TextReplacer.addTextReplacement(replacementText, textComponent);
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Successfully added the text replacement \"" + replacementText + "\"")));
        return 1;
    }

    private static int removeReplacement(FabricClientCommandSource source, String replacementText) {
        boolean success = TextReplacer.removeTextReplacement(replacementText);
        if (success) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Successfully removed the text replacement for \"" + replacementText + "\"")));
        } else {
            source.sendError((class_2561)class_2561.method_43470((String)"That text replacement never existed!"));
        }
        return 1;
    }
}

