/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.Cache;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.Http;
import net.azureaaron.mod.utils.Messages;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.slf4j.Logger;

public class BazaarCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Supplier<class_5250> NON_EXISTENT_PRODUCT_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"The product you've provided is non existent!").method_27692(class_124.field_1061));
    private static final Supplier<class_5250> BAZAAR_FETCH_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"There was an error while fetching information from the bazaar!").method_27692(class_124.field_1061));

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(BazaarCommand::register);
        }
    }

    private static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        LiteralCommandNode bazaarCommand = dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bazaarprice").then(ClientCommandManager.argument((String)"product", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(Cache.PRODUCTS_LIST, (SuggestionsBuilder)builder)).executes(context -> BazaarCommand.handleCommand((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"product")))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bzprice").redirect((CommandNode)bazaarCommand));
    }

    private static int handleCommand(FabricClientCommandSource source, String product) {
        if (!Cache.PRODUCTS_LIST.contains(product)) {
            source.sendError((class_2561)NON_EXISTENT_PRODUCT_ERROR.get());
            return 1;
        }
        CompletableFuture.supplyAsync(() -> {
            try {
                String response = Http.sendGetRequest("https://api.hypixel.net/v2/skyblock/bazaar");
                JsonObject data = JsonParser.parseString((String)response).getAsJsonObject();
                return data.get("products").getAsJsonObject().get(Cache.PRODUCTS_MAP.get(product)).getAsJsonObject().get("quick_status").getAsJsonObject();
            }
            catch (Exception e) {
                source.sendError((class_2561)BAZAAR_FETCH_ERROR.get());
                LOGGER.error("[Aaron's Mod] Failed to load bazaar price data!", (Throwable)e);
                return null;
            }
        }).thenAccept(productData -> {
            if (productData != null) {
                try {
                    BazaarCommand.printBazaar(source, productData, product);
                }
                catch (Throwable t) {
                    source.sendError((class_2561)Messages.UNKNOWN_ERROR.get());
                    LOGGER.error("[Aaron's Mod] Encountered an unknown error while executing the /bazaar command!", t);
                }
            }
        });
        return 1;
    }

    private static void printBazaar(FabricClientCommandSource source, JsonObject productData, String productName) {
        RenderHelper.runOnRenderThread(() -> {
            Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
            class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)productName).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
            source.sendFeedback((class_2561)startText);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Buy Price \u00bb " + Formatters.DOUBLE_NUMBERS.format(productData.get("buyPrice").getAsDouble()))).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)(Formatters.SHORT_INTEGER_NUMBERS.format(productData.get("buyVolume").getAsInt()) + " in " + Formatters.SHORT_INTEGER_NUMBERS.format(productData.get("buyOrders").getAsInt()) + " offers")).method_54663(colourProfile.supportingInfoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)(Formatters.SHORT_INTEGER_NUMBERS.format(productData.get("buyMovingWeek").getAsInt()) + " insta-buys in 7 days")).method_54663(colourProfile.supportingInfoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Sell Price \u00bb " + Formatters.DOUBLE_NUMBERS.format(productData.get("sellPrice").getAsDouble()))).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)(Formatters.SHORT_INTEGER_NUMBERS.format(productData.get("sellVolume").getAsInt()) + " in " + Formatters.SHORT_INTEGER_NUMBERS.format(productData.get("sellOrders").getAsInt()) + " orders")).method_54663(colourProfile.supportingInfoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)(Formatters.SHORT_INTEGER_NUMBERS.format(productData.get("sellMovingWeek").getAsInt()) + " insta-sells in 7 days")).method_54663(colourProfile.supportingInfoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
    }
}

