/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.Command;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.commands.SkyblockCommand;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.Functions;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.mod.utils.Skyblock;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CrimsonCommand
extends SkyblockCommand {
    private static final Command INSTANCE = new CrimsonCommand();

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(INSTANCE::register);
        }
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"crimson").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
    }

    @Override
    public void print(FabricClientCommandSource source, JsonObject body, String name, String uuid) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        JsonObject profile = body.getAsJsonObject("members").getAsJsonObject(uuid);
        JsonObject crimsonIsleStats = profile.getAsJsonObject("nether_island_player_data");
        String selectedFaction = JsonHelper.getString(crimsonIsleStats, "selected_faction").orElse("None");
        int barbarianColour = selectedFaction.equals("barbarians") ? colourProfile.highlightColour.getAsInt() : colourProfile.infoColour.getAsInt();
        int mageColour = selectedFaction.equals("mages") ? colourProfile.highlightColour.getAsInt() : colourProfile.infoColour.getAsInt();
        int barbarianReputation = JsonHelper.getInt(crimsonIsleStats, "barbarians_reputation").orElse(0);
        int mageReputation = JsonHelper.getInt(crimsonIsleStats, "mages_reputation").orElse(0);
        JsonObject kuudraTierCompletions = crimsonIsleStats.getAsJsonObject("kuudra_completed_tiers");
        int basicCompletions = JsonHelper.getInt(kuudraTierCompletions, "none").orElse(0);
        int hotCompletions = JsonHelper.getInt(kuudraTierCompletions, "hot").orElse(0);
        int burningCompletions = JsonHelper.getInt(kuudraTierCompletions, "burning").orElse(0);
        int fieryCompletions = JsonHelper.getInt(kuudraTierCompletions, "fiery").orElse(0);
        int infernalCompletions = JsonHelper.getInt(kuudraTierCompletions, "infernal").orElse(0);
        int totalKuudraCompletions = basicCompletions + hotCompletions + burningCompletions + fieryCompletions + infernalCompletions;
        int totalKuudraCollection = basicCompletions + hotCompletions * 2 + burningCompletions * 3 + fieryCompletions * 4 + infernalCompletions * 5;
        JsonObject dojoStats = crimsonIsleStats.getAsJsonObject("dojo");
        int forceScore = JsonHelper.getInt(dojoStats, "dojo_points_mob_kb").orElse(0);
        int staminaScore = JsonHelper.getInt(dojoStats, "dojo_points_wall_jump").orElse(0);
        int masteryScore = JsonHelper.getInt(dojoStats, "dojo_points_archer").orElse(0);
        int disciplineScore = JsonHelper.getInt(dojoStats, "dojo_points_sword_swap").orElse(0);
        int swiftnessScore = JsonHelper.getInt(dojoStats, "dojo_points_snake").orElse(0);
        int controlScore = JsonHelper.getInt(dojoStats, "dojo_points_lock_head").orElse(0);
        int tenacityScore = JsonHelper.getInt(dojoStats, "dojo_points_fireball").orElse(0);
        int totalDojoScore = forceScore + staminaScore + masteryScore + disciplineScore + swiftnessScore + controlScore + tenacityScore;
        String forceGrade = Skyblock.getDojoGrade(forceScore);
        String staminaGrade = Skyblock.getDojoGrade(staminaScore);
        String masteryGrade = Skyblock.getDojoGrade(masteryScore);
        String disciplineGrade = Skyblock.getDojoGrade(disciplineScore);
        String swiftnessGrade = Skyblock.getDojoGrade(swiftnessScore);
        String controlGrade = Skyblock.getDojoGrade(controlScore);
        String tenacityGrade = Skyblock.getDojoGrade(tenacityScore);
        RenderHelper.runOnRenderThread(() -> {
            class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
            source.sendFeedback((class_2561)startText);
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Faction \u00bb ").method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)Functions.titleCase(selectedFaction)).method_54663(colourProfile.highlightColour.getAsInt())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"[ B \u00bb ").method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(barbarianReputation)).method_54663(barbarianColour)).method_10852((class_2561)class_2561.method_43470((String)" \u2022 M \u00bb ").method_54663(colourProfile.infoColour.getAsInt())).method_10852((class_2561)class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(mageReputation)).method_54663(mageColour)).method_10852((class_2561)class_2561.method_43470((String)" ]")));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"(Kuudra Completions)").method_27694(style -> style.method_36139(colourProfile.hoverColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Total Completions \u00bb " + Formatters.INTEGER_NUMBERS.format(totalKuudraCompletions) + "\n")).method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)("Total Collection \u00bb " + Formatters.INTEGER_NUMBERS.format(totalKuudraCollection) + "\n\n"))).method_10852((class_2561)class_2561.method_43470((String)("Basic \u00bb " + Formatters.INTEGER_NUMBERS.format(basicCompletions) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("Hot \u00bb " + Formatters.INTEGER_NUMBERS.format(hotCompletions) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("Burning \u00bb " + Formatters.INTEGER_NUMBERS.format(burningCompletions) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("Fiery \u00bb " + Formatters.INTEGER_NUMBERS.format(fieryCompletions) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("Infernal \u00bb " + Formatters.INTEGER_NUMBERS.format(infernalCompletions))))))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"(Dojo Tests)").method_27694(style -> style.method_36139(colourProfile.hoverColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Total Score \u00bb " + Formatters.INTEGER_NUMBERS.format(totalDojoScore) + "\n")).method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)("Force \u00bb " + forceGrade + " (" + Formatters.INTEGER_NUMBERS.format(forceScore) + ") \n"))).method_10852((class_2561)class_2561.method_43470((String)("Stamina \u00bb " + staminaGrade + " (" + Formatters.INTEGER_NUMBERS.format(staminaScore) + ") \n"))).method_10852((class_2561)class_2561.method_43470((String)("Mastery \u00bb " + masteryGrade + " (" + Formatters.INTEGER_NUMBERS.format(masteryScore) + ") \n"))).method_10852((class_2561)class_2561.method_43470((String)("Discipline \u00bb " + disciplineGrade + " (" + Formatters.INTEGER_NUMBERS.format(disciplineScore) + ") \n"))).method_10852((class_2561)class_2561.method_43470((String)("Swiftness \u00bb " + swiftnessGrade + " (" + Formatters.INTEGER_NUMBERS.format(swiftnessScore) + ") \n"))).method_10852((class_2561)class_2561.method_43470((String)("Control \u00bb " + controlGrade + " (" + Formatters.INTEGER_NUMBERS.format(controlScore) + ") \n"))).method_10852((class_2561)class_2561.method_43470((String)("Tenacity \u00bb " + tenacityGrade + " (" + Formatters.INTEGER_NUMBERS.format(tenacityScore) + ")")))))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
    }
}

