/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.Command;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.commands.SkyblockCommand;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.Skyblock;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9276;
import net.minecraft.class_9334;

public class CroesusCommand
extends SkyblockCommand {
    private static final Command INSTANCE = new CroesusCommand();
    private static final long TWO_DAYS = 172800000L;
    private static final Supplier<class_5250> NO_TREASURES = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"This player doesn't have any dungeon treasures to claim!").method_27692(class_124.field_1061));

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(INSTANCE::register);
        }
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"croesus").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
    }

    @Override
    public void print(FabricClientCommandSource source, JsonObject body, String name, String uuid) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        JsonObject profile = body.getAsJsonObject("members").getAsJsonObject(uuid);
        JsonObject treasures = profile.getAsJsonObject("dungeons").getAsJsonObject("treasures");
        if (treasures.get("runs") == null) {
            source.sendError((class_2561)NO_TREASURES.get());
            return;
        }
        long twoDaysAgo = System.currentTimeMillis() - 172800000L;
        HashMap<String, RunData> runs = new HashMap<String, RunData>();
        HashSet<String> ineligibleRuns = new HashSet<String>();
        for (JsonElement run : treasures.get("runs").getAsJsonArray()) {
            JsonObject iteratedRun = run.getAsJsonObject();
            if (iteratedRun.get("type").getAsString().equals("KUUDRA")) continue;
            if (iteratedRun.get("completion_ts").getAsLong() > twoDaysAgo && iteratedRun.get("dungeon_tier").getAsInt() != 0) {
                runs.put(iteratedRun.get("run_id").getAsString(), new RunData(iteratedRun.get("completion_ts").getAsLong(), iteratedRun.get("dungeon_tier").getAsInt(), iteratedRun.get("dungeon_type").getAsString(), new ArrayList<ChestData>()));
                continue;
            }
            ineligibleRuns.add(iteratedRun.get("run_id").getAsString());
        }
        if (runs.size() == 0) {
            source.sendError((class_2561)NO_TREASURES.get());
            return;
        }
        HashSet<String> claimedRuns = new HashSet<String>();
        HashSet<ChestData> chests = new HashSet<ChestData>();
        ArrayList rewards = new ArrayList();
        for (JsonElement chest2 : treasures.get("chests").getAsJsonArray()) {
            JsonObject iteratedChest = chest2.getAsJsonObject();
            String chestRunId = iteratedChest.get("run_id").getAsString();
            boolean chestPaid = iteratedChest.get("paid").getAsBoolean();
            if (iteratedChest.get("type").getAsString().equals("KUUDRA")) continue;
            if (!claimedRuns.contains(chestRunId) && chestPaid) {
                claimedRuns.add(chestRunId);
                runs.remove(chestRunId);
                continue;
            }
            if (chestPaid) continue;
            chests.add(new ChestData(chestRunId, iteratedChest.get("treasure_type").getAsString(), iteratedChest.get("rewards").getAsJsonObject().get("rewards").getAsJsonArray()));
        }
        chests.forEach(chest -> {
            if (!claimedRuns.contains(chest.runId()) && !ineligibleRuns.contains(chest.runId())) {
                RunData old = (RunData)runs.get(chest.runId());
                runs.put(chest.runId(), new RunData(old.timestamp(), old.floor(), old.dungeon(), Stream.concat(old.chests().stream(), Arrays.asList(chest).stream()).toList()));
                chest.rewards().forEach(element -> {
                    String stringForm = element.getAsString();
                    boolean isRareLoot = Skyblock.getRareLootItems().keySet().stream().anyMatch(stringForm::equals);
                    if (isRareLoot || !isRareLoot && !rewards.contains(stringForm)) {
                        rewards.add(stringForm);
                    }
                });
            }
        });
        if (runs.size() == 0) {
            source.sendError((class_2561)NO_TREASURES.get());
            return;
        }
        String rewardsString = ((Object)rewards).toString();
        boolean rareLootAwaits = Skyblock.getRareLootItems().keySet().stream().anyMatch(rewardsString::contains);
        Function<String, Boolean> containsRareLoot = s -> Skyblock.getRareLootItems().keySet().stream().anyMatch(s::equals);
        List rareLoot = rewards.stream().filter(e -> (Boolean)containsRareLoot.apply((String)e)).collect(Collectors.toList());
        class_1799 bundle = class_1802.field_27023.method_7854();
        bundle.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"\u2726 Rare Loot Preview \u2726").method_27694(style -> style.method_10978(Boolean.valueOf(false)).method_36139(colourProfile.infoColour.getAsInt())));
        HashMap<String, class_1799> stacks = new HashMap<String, class_1799>();
        for (String item : rareLoot) {
            int occurrences = Collections.frequency(rareLoot, item);
            if (stacks.containsKey(item)) continue;
            stacks.put(item, (class_1799)class_156.method_654((Object)Skyblock.getRareLootItems().get(item).method_7972(), stack -> stack.method_7939(occurrences)));
        }
        bundle.method_57379(class_9334.field_49650, (Object)new class_9276(new ArrayList(stacks.values())));
        RenderHelper.runOnRenderThread(() -> {
            class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
            source.sendFeedback((class_2561)startText);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Unclaimed Chests \u00bb " + runs.size())).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Rare Loot Awaits \u00bb " + (rareLootAwaits ? "\u2713" : "\u2717"))).method_27694(style -> style.method_36139(colourProfile.infoColour.getAsInt()).method_10949((class_2568)new class_2568.class_10612(bundle))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            int count = 0;
            for (RunData run : runs.values()) {
                if (count > 10) continue;
                String floorShorthand = String.valueOf(Character.toUpperCase(run.dungeon().charAt(0))).replace('C', 'F') + run.floor();
                String timeAgo = Formatters.toRelativeTime(System.currentTimeMillis() - run.timestamp()).atMost(2);
                long expiresAt = run.timestamp() + 172800000L;
                long expiresIn = run.timestamp() + 172800000L - System.currentTimeMillis();
                source.sendFeedback((class_2561)class_2561.method_43470((String)("(" + floorShorthand + " \u2022 " + timeAgo + ")")).method_27694(style -> style.method_36139(colourProfile.hoverColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Expires:\n" + Formatters.DATE_FORMATTER.format(Instant.ofEpochMilli(expiresAt)) + "\n(In " + TimeUnit.MILLISECONDS.toHours(expiresIn) + " hours)")).method_54663(colourProfile.infoColour.getAsInt())))));
                ++count;
            }
            if (count > 10) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)("and " + (runs.size() - 10) + " more...")).method_27694(style -> style.method_36139(colourProfile.supportingInfoColour.getAsInt()).method_10978(Boolean.valueOf(true))));
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
    }

    private record RunData(long timestamp, int floor, String dungeon, List<ChestData> chests) {
    }

    private record ChestData(String runId, String type, JsonArray rewards) {
    }
}

