/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.Command;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.commands.SkyblockCommand;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.Functions;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.mod.utils.Levelling;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class DungeonsCommand
extends SkyblockCommand {
    private static final Command INSTANCE = new DungeonsCommand();
    private static final Supplier<class_5250> NEVER_PLAYED_DUNGEONS_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"This player hasn't entered the catacombs yet!").method_27692(class_124.field_1061));

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(INSTANCE::register);
        }
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dungeons").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"catacombs").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cata").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
    }

    @Override
    public void print(FabricClientCommandSource source, JsonObject body, String name, String uuid) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        if (body.getAsJsonObject("members").getAsJsonObject(uuid).getAsJsonObject("dungeons").getAsJsonObject("dungeon_types").getAsJsonObject("catacombs").get("times_played") == null) {
            source.sendError((class_2561)NEVER_PLAYED_DUNGEONS_ERROR.get());
            return;
        }
        JsonObject profile = body.getAsJsonObject("members").getAsJsonObject(uuid);
        JsonObject dungeonsStats = profile.getAsJsonObject("dungeons");
        int healerLevel = Levelling.getDungeonLevel(JsonHelper.getLong(dungeonsStats, "player_classes.healer.experience").orElse(0L));
        int mageLevel = Levelling.getDungeonLevel(JsonHelper.getLong(dungeonsStats, "player_classes.mage.experience").orElse(0L));
        int berserkLevel = Levelling.getDungeonLevel(JsonHelper.getLong(dungeonsStats, "player_classes.berserk.experience").orElse(0L));
        int archerLevel = Levelling.getDungeonLevel(JsonHelper.getLong(dungeonsStats, "player_classes.archer.experience").orElse(0L));
        int tankLevel = Levelling.getDungeonLevel(JsonHelper.getLong(dungeonsStats, "player_classes.tank.experience").orElse(0L));
        float classAverage = (float)(healerLevel + mageLevel + berserkLevel + archerLevel + tankLevel) / 5.0f;
        JsonObject catacombsStats = dungeonsStats.getAsJsonObject("dungeon_types").getAsJsonObject("catacombs");
        long catacombsXp = JsonHelper.getLong(catacombsStats, "experience").orElse(0L);
        int catacombsLevel = Levelling.getDungeonLevel(catacombsXp);
        int secrets = JsonHelper.getInt(dungeonsStats, "secrets").orElse(0);
        String selectedClass = JsonHelper.getString(dungeonsStats, "selected_dungeon_class").orElse("None");
        int healerColour = "healer".equals(selectedClass) ? colourProfile.highlightColour.getAsInt() : colourProfile.infoColour.getAsInt();
        int mageColour = "mage".equals(selectedClass) ? colourProfile.highlightColour.getAsInt() : colourProfile.infoColour.getAsInt();
        int berserkColour = "berserk".equals(selectedClass) ? colourProfile.highlightColour.getAsInt() : colourProfile.infoColour.getAsInt();
        int archerColour = "archer".equals(selectedClass) ? colourProfile.highlightColour.getAsInt() : colourProfile.infoColour.getAsInt();
        int tankColour = "tank".equals(selectedClass) ? colourProfile.highlightColour.getAsInt() : colourProfile.infoColour.getAsInt();
        JsonElement dailyRuns = dungeonsStats.get("daily_runs");
        JsonElement completedDailyRuns = dailyRuns != null ? dailyRuns.getAsJsonObject().get("completed_runs_count") : null;
        boolean onDailies = dailyRuns != null && completedDailyRuns != null && dailyRuns.getAsJsonObject().get("current_day_stamp").getAsLong() == Instant.EPOCH.until(Instant.now(), ChronoUnit.DAYS) && completedDailyRuns.getAsInt() < 5;
        String dailiesLeft = onDailies ? " (" + (5 - completedDailyRuns.getAsInt()) + ")" : "";
        JsonObject tierCompletions = catacombsStats.getAsJsonObject("tier_completions");
        int entrances = JsonHelper.getInt(tierCompletions, "0").orElse(0);
        int floor1s = JsonHelper.getInt(tierCompletions, "1").orElse(0);
        int floor2s = JsonHelper.getInt(tierCompletions, "2").orElse(0);
        int floor3s = JsonHelper.getInt(tierCompletions, "3").orElse(0);
        int floor4s = JsonHelper.getInt(tierCompletions, "4").orElse(0);
        int floor5s = JsonHelper.getInt(tierCompletions, "5").orElse(0);
        int floor6s = JsonHelper.getInt(tierCompletions, "6").orElse(0);
        int floor7s = JsonHelper.getInt(tierCompletions, "7").orElse(0);
        JsonObject masterModeStats = dungeonsStats.getAsJsonObject("dungeon_types").getAsJsonObject("master_catacombs");
        JsonObject masterTierCompletions = masterModeStats.getAsJsonObject("tier_completions");
        int masterFloor1s = JsonHelper.getInt(masterTierCompletions, "1").orElse(0);
        int masterFloor2s = JsonHelper.getInt(masterTierCompletions, "2").orElse(0);
        int masterFloor3s = JsonHelper.getInt(masterTierCompletions, "3").orElse(0);
        int masterFloor4s = JsonHelper.getInt(masterTierCompletions, "4").orElse(0);
        int masterFloor5s = JsonHelper.getInt(masterTierCompletions, "5").orElse(0);
        int masterFloor6s = JsonHelper.getInt(masterTierCompletions, "6").orElse(0);
        int masterFloor7s = JsonHelper.getInt(masterTierCompletions, "7").orElse(0);
        RenderHelper.runOnRenderThread(() -> {
            class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
            source.sendFeedback((class_2561)startText);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Level \u00bb " + catacombsLevel)).method_27694(style -> style.method_36139(colourProfile.infoColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Total XP: " + Formatters.INTEGER_NUMBERS.format(catacombsXp))).method_54663(colourProfile.infoColour.getAsInt())))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Dailies \u00bb " + (onDailies ? "\u2713" : "\u2717") + dailiesLeft)).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Secrets \u00bb " + Formatters.INTEGER_NUMBERS.format(secrets))).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Selected Class \u00bb ").method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)Functions.titleCase(selectedClass)).method_54663(colourProfile.highlightColour.getAsInt())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"[ H \u00bb ").method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(healerLevel)).method_54663(healerColour)).method_10852((class_2561)class_2561.method_43470((String)" \u2022 M \u00bb ").method_54663(colourProfile.infoColour.getAsInt())).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(mageLevel)).method_54663(mageColour)).method_10852((class_2561)class_2561.method_43470((String)" \u2022 B \u00bb ").method_54663(colourProfile.infoColour.getAsInt())).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(berserkLevel)).method_54663(berserkColour)).method_10852((class_2561)class_2561.method_43470((String)" \u2022 A \u00bb ").method_54663(colourProfile.infoColour.getAsInt())).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(archerLevel)).method_54663(archerColour)).method_10852((class_2561)class_2561.method_43470((String)" \u2022 T \u00bb ").method_54663(colourProfile.infoColour.getAsInt())).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(tankLevel)).method_54663(tankColour)).method_10852((class_2561)class_2561.method_43470((String)" ]").method_54663(colourProfile.infoColour.getAsInt())).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Class Avg. \u00bb " + String.valueOf(classAverage))).method_54663(colourProfile.infoColour.getAsInt())))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"(Catacombs Completions)").method_27694(style -> style.method_36139(colourProfile.hoverColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Entrance \u00bb " + Formatters.INTEGER_NUMBERS.format(entrances) + "\n")).method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)("F1 \u00bb " + Formatters.INTEGER_NUMBERS.format(floor1s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("F2 \u00bb " + Formatters.INTEGER_NUMBERS.format(floor2s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("F3 \u00bb " + Formatters.INTEGER_NUMBERS.format(floor3s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("F4 \u00bb " + Formatters.INTEGER_NUMBERS.format(floor4s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("F5 \u00bb " + Formatters.INTEGER_NUMBERS.format(floor5s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("F6 \u00bb " + Formatters.INTEGER_NUMBERS.format(floor6s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("F7 \u00bb " + Formatters.INTEGER_NUMBERS.format(floor7s))))))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"(Master Catacombs Completions)").method_27694(style -> style.method_36139(colourProfile.hoverColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("M1 \u00bb " + Formatters.INTEGER_NUMBERS.format(masterFloor1s) + "\n")).method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)("M2 \u00bb " + Formatters.INTEGER_NUMBERS.format(masterFloor2s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("M3 \u00bb " + Formatters.INTEGER_NUMBERS.format(masterFloor3s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("M4 \u00bb " + Formatters.INTEGER_NUMBERS.format(masterFloor4s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("M5 \u00bb " + Formatters.INTEGER_NUMBERS.format(masterFloor5s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("M6 \u00bb " + Formatters.INTEGER_NUMBERS.format(masterFloor6s) + "\n"))).method_10852((class_2561)class_2561.method_43470((String)("M7 \u00bb " + Formatters.INTEGER_NUMBERS.format(masterFloor7s))))))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
    }
}

