/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.Command;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.commands.SkyblockCommand;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.ItemUtils;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.mod.utils.Messages;
import net.azureaaron.mod.utils.Skyblock;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9322;
import org.slf4j.Logger;

public class InventoryCommand
extends SkyblockCommand {
    private static final Command INSTANCE = new InventoryCommand();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Supplier<class_5250> NBT_PARSING_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"There was an error while trying to parse NBT!").method_27692(class_124.field_1061));

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(INSTANCE::register);
        }
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"inventory").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"inv").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
    }

    @Override
    public void print(FabricClientCommandSource source, JsonObject body, String name, String uuid) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        JsonObject profile = body.getAsJsonObject("members").getAsJsonObject(uuid);
        JsonObject inventoryData = profile.getAsJsonObject("inventory");
        boolean inventoryEnabled = Skyblock.isInventoryApiEnabled(inventoryData);
        if (!inventoryEnabled) {
            source.sendError((class_2561)Messages.INVENTORY_API_DISABLED_ERROR.get());
            return;
        }
        List<class_1799> armour = null;
        List<class_1799> inventory = null;
        List<class_1799> equipment = null;
        try {
            armour = ItemUtils.parseCompressedItemData(JsonHelper.getString(inventoryData, "inv_armor.data").orElseThrow());
            inventory = ItemUtils.parseCompressedItemData(JsonHelper.getString(inventoryData, "inv_contents.data").orElseThrow());
            equipment = ItemUtils.parseCompressedItemData(JsonHelper.getString(inventoryData, "equipment_contents.data").orElseThrow());
        }
        catch (IOException | NullPointerException e) {
            source.sendError((class_2561)NBT_PARSING_ERROR.get());
            LOGGER.error("[Aaron's Mod] Encountered an exception while parsing NBT!", (Throwable)e);
            return;
        }
        ItemData4 boots = new ItemData4(armour.get(0), "No boots equipped!");
        ItemData4 leggings = new ItemData4(armour.get(1), "No leggings equipped!");
        ItemData4 chestplate = new ItemData4(armour.get(2), "No chestplate equipped!");
        ItemData4 helmet = new ItemData4(armour.get(3), "No helmet equipped!");
        ItemData4[] equipmentPieces = new ItemData4[4];
        if (equipment != null) {
            equipmentPieces[0] = new ItemData4(equipment.get(0), "No necklace equipped!");
            equipmentPieces[1] = new ItemData4(equipment.get(1), "No cloak equipped!");
            equipmentPieces[2] = new ItemData4(equipment.get(2), "No belt equipped!");
            equipmentPieces[3] = new ItemData4(equipment.get(3), "No gloves or bracelet equipped!");
        }
        ObjectArrayList keyItems = new ObjectArrayList();
        if (inventoryEnabled) {
            for (class_1799 stack : inventory) {
                String itemId = ItemUtils.getId((class_9322)stack);
                if (!itemId.equals("ASTRAEA") && !itemId.equals("HYPERION") && !itemId.equals("SCYLLA") && !itemId.equals("VALKYRIE") && !itemId.equals("TERMINATOR") && !itemId.equals("DARK_CLAYMORE")) continue;
                keyItems.add((Object)new ItemData4(stack, "Error parsing item :("));
            }
        }
        keyItems.sort(Comparator.comparing(id -> id.stack().method_7964().getString()));
        List<class_1799> equipmentFinal = equipment;
        RenderHelper.runOnRenderThread(() -> {
            class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
            source.sendFeedback((class_2561)startText);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Inventory API \u00bb " + (inventoryEnabled ? "\u2713" : "\u2717"))).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            source.sendFeedback((class_2561)helmet.feedbackMessage());
            source.sendFeedback((class_2561)chestplate.feedbackMessage());
            source.sendFeedback((class_2561)leggings.feedbackMessage());
            source.sendFeedback((class_2561)boots.feedbackMessage());
            if (equipmentFinal != null) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                source.sendFeedback((class_2561)equipmentPieces[0].feedbackMessage());
                source.sendFeedback((class_2561)equipmentPieces[1].feedbackMessage());
                source.sendFeedback((class_2561)equipmentPieces[2].feedbackMessage());
                source.sendFeedback((class_2561)equipmentPieces[3].feedbackMessage());
            }
            if (keyItems.size() > 0) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                for (ItemData4 item : keyItems) {
                    source.sendFeedback((class_2561)item.feedbackMessage());
                }
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
    }

    private record ItemData4(class_1799 stack, String fallback) {
        private class_5250 feedbackMessage() {
            if (!this.stack.method_7960()) {
                return this.stack.method_7964().method_27661().method_27694(style -> style.method_10949((class_2568)new class_2568.class_10612(this.stack)));
            }
            return class_2561.method_43470((String)this.fallback).method_27692(class_124.field_1061);
        }
    }
}

