/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.config.configs.SkyblockConfig;
import net.azureaaron.mod.utils.Cache;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.Http;
import net.azureaaron.mod.utils.Messages;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.slf4j.Logger;

public class LowestBinCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Supplier<class_5250> LOWEST_BIN_FETCH_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"There was an error while fetching information for the lowest bin prices!").method_27692(class_124.field_1061));
    private static final Supplier<class_5250> DAY_AVERAGE_FETCH_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"There was an error while fetching information for the average day price!").method_27692(class_124.field_1061));
    private static final Supplier<class_5250> NON_EXISTENT_ITEM_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"The item you've provided is non existent!").method_27692(class_124.field_1061));
    private static final Supplier<class_5250> NO_AVERAGE_PRICE_FOR_ITEM_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"No average price was found! (Most likely because this item hasn't been on the auction house recently!)").method_27692(class_124.field_1061));

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(LowestBinCommand::register);
        }
    }

    private static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        LiteralCommandNode lowestBinCommand = dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lowestbin").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(Cache.ITEMS_LIST, (SuggestionsBuilder)builder)).executes(context -> LowestBinCommand.handleCommand((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"item")))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lbin").redirect((CommandNode)lowestBinCommand));
    }

    private static int handleCommand(FabricClientCommandSource source, String item) {
        int average;
        String itemId = Cache.ITEM_NAMES.get(item);
        if (!Cache.ITEMS_LIST.contains(item)) {
            source.sendError((class_2561)NON_EXISTENT_ITEM_ERROR.get());
            return 1;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                String lowestBinResponse = Http.sendGetRequest("https://moulberry.codes/lowestbin.json");
                JsonObject lowestBin = JsonParser.parseString((String)lowestBinResponse).getAsJsonObject();
                JsonObject priceObject = new JsonObject();
                priceObject.addProperty("price", (Number)lowestBin.get(itemId).getAsLong());
                return priceObject;
            }
            catch (Exception e) {
                source.sendError((class_2561)LOWEST_BIN_FETCH_ERROR.get());
                LOGGER.error("[Aaron's Mod] Encountered an exception while fetching lbin prices!", (Throwable)e);
                return null;
            }
        }).thenApply(itemPrice -> {
            if (itemPrice == null) {
                return null;
            }
            try {
                String dayAverageResponse = Http.sendGetRequest("https://moulberry.codes/auction_averages_lbin/" + average + "day.json");
                JsonObject dayAverage = JsonParser.parseString((String)dayAverageResponse).getAsJsonObject();
                if (dayAverage.get(itemId) == null) {
                    source.sendError((class_2561)NO_AVERAGE_PRICE_FOR_ITEM_ERROR.get());
                    return null;
                }
                JsonObject response = new JsonObject();
                response.addProperty("price", (Number)itemPrice.get("price").getAsLong());
                response.addProperty("dayAverage", (Number)dayAverage.get(itemId).getAsLong());
                return response;
            }
            catch (Exception e) {
                source.sendError((class_2561)DAY_AVERAGE_FETCH_ERROR.get());
                LOGGER.error("[Aaron's Mod] Encountered an exception while fetching lbin day average prices!", (Throwable)e);
                return null;
            }
        })).thenAccept(arg_0 -> LowestBinCommand.lambda$handleCommand$8(source, item, switch (AaronModConfigManager.get().skyblock.commands.lbinPriceDayAverage) {
            case SkyblockConfig.DayAverage.ONE_DAY -> {
                average = 1;
                yield "1 Day Avg.";
            }
            case SkyblockConfig.DayAverage.THREE_DAY -> {
                average = 3;
                yield "3 Day Avg.";
            }
            case SkyblockConfig.DayAverage.SEVEN_DAY -> {
                average = 7;
                yield "7 Day Avg.";
            }
            default -> {
                average = 3;
                yield "3 Day Avg.";
            }
        }, arg_0));
        return 1;
    }

    private static void printLowestBin(FabricClientCommandSource source, JsonObject data, String itemName, String desc) {
        RenderHelper.runOnRenderThread(() -> {
            Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
            class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)itemName).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
            source.sendFeedback((class_2561)startText);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Lowest BIN Price \u00bb " + Formatters.INTEGER_NUMBERS.format(data.get("price").getAsLong()))).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            source.sendFeedback((class_2561)class_2561.method_43470((String)(desc + " Price \u00bb " + Formatters.INTEGER_NUMBERS.format(data.get("dayAverage").getAsLong()))).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
    }

    private static /* synthetic */ void lambda$handleCommand$8(FabricClientCommandSource source, String item, String averageDescription, JsonObject data) {
        if (data != null) {
            try {
                LowestBinCommand.printLowestBin(source, data, item, averageDescription);
            }
            catch (Exception e) {
                source.sendError((class_2561)Messages.UNKNOWN_ERROR.get());
                LOGGER.error("[Aaron's Mod] Encountered an exception while printing lbin feedback messages!", (Throwable)e);
            }
        }
    }
}

