/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.io.IOException;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.Command;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.commands.SkyblockCommand;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.skyblock.item.Accessories;
import net.azureaaron.mod.skyblock.item.Accessory;
import net.azureaaron.mod.skyblock.item.MagicalPower;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.Functions;
import net.azureaaron.mod.utils.ItemUtils;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.mod.utils.Messages;
import net.azureaaron.mod.utils.Skyblock;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9290;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.slf4j.Logger;

public class MagicalPowerCommand
extends SkyblockCommand {
    private static final Command INSTANCE = new MagicalPowerCommand();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Supplier<class_5250> NO_ACCESSORY_BAG_DATA = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"This profile doesn't have any accessory bag data!").method_27692(class_124.field_1061));
    private static final Supplier<class_5250> NBT_PARSING_ERROR = () -> Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"There was an error while trying to parse NBT!").method_27692(class_124.field_1061));
    private static final Pattern ACCESSORY_RARITY_PATTERN = Pattern.compile("(?:a )?(?<rarity>(?:VERY )?[A-Za-z]+) (?:DUNGEON )?(?:AC|HAT)CESSORY(?: a)?");
    private static final IntToDoubleFunction STATS_MULT = magicalPower -> 29.97 * Math.pow(Math.log(Math.fma(0.0019, (double)magicalPower, 1.0)), 1.2);
    private static final Object2IntOpenHashMap<String> RARITY_TIER_MAP = (Object2IntOpenHashMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"VERY SPECIAL", 8);
        map.put((Object)"SPECIAL", 7);
        map.put((Object)"MYTHIC", 6);
        map.put((Object)"LEGENDARY", 5);
        map.put((Object)"EPIC", 4);
        map.put((Object)"RARE", 3);
        map.put((Object)"UNCOMMON", 2);
        map.put((Object)"COMMON", 1);
    });

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(INSTANCE::register);
        }
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"magicalpower").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mp").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
    }

    @Override
    public void print(FabricClientCommandSource source, JsonObject body, String name, String uuid) {
        JsonObject riftAccess;
        List<class_1799> accessories;
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        JsonObject profile = body.getAsJsonObject("members").getAsJsonObject(uuid);
        JsonObject inventoryData = profile.getAsJsonObject("inventory");
        boolean inventoryEnabled = Skyblock.isInventoryApiEnabled(inventoryData);
        if (!inventoryEnabled) {
            source.sendError((class_2561)Messages.INVENTORY_API_DISABLED_ERROR.get());
            return;
        }
        JsonObject accessoryBagStorage = profile.getAsJsonObject("accessory_bag_storage");
        if (accessoryBagStorage == null) {
            source.sendError((class_2561)NO_ACCESSORY_BAG_DATA.get());
            return;
        }
        try {
            accessories = ItemUtils.parseCompressedItemData(JsonHelper.getString(inventoryData, "bag_contents.talisman_bag.data").orElseThrow());
        }
        catch (IOException e) {
            source.sendError((class_2561)NBT_PARSING_ERROR.get());
            LOGGER.error("[Aaron's Mod] Encountered an exception while parsing NBT!", (Throwable)e);
            return;
        }
        ObjectArrayList collectedAccessoriesFromBag = new ObjectArrayList();
        block22: for (class_1799 stack : accessories) {
            if (!stack.method_57826(class_9334.field_49632)) continue;
            String itemId = ItemUtils.getId((class_9322)stack);
            for (class_2561 line : ((class_9290)stack.method_58694(class_9334.field_49632)).comp_2400().reversed()) {
                String loreLine = class_124.method_539((String)line.getString());
                Matcher matcher = ACCESSORY_RARITY_PATTERN.matcher(loreLine);
                if (itemId.isBlank() || !matcher.matches()) continue;
                collectedAccessoriesFromBag.add((Object)ObjectObjectImmutablePair.of((Object)Accessories.getAccessories().getOrDefault(itemId, Accessory.fromId(itemId)), (Object)matcher.group("rarity")));
                continue block22;
            }
        }
        Object2ObjectOpenHashMap collectedAccessories = collectedAccessoriesFromBag.stream().filter(pair -> {
            Accessory accessory = (Accessory)pair.left();
            int highestTierOfSameCollected = collectedAccessoriesFromBag.stream().filter(c -> ((Accessory)c.left()).id().equals(accessory.id())).mapToInt(c -> RARITY_TIER_MAP.getOrDefault(c.right(), 0)).max().orElse(0);
            return highestTierOfSameCollected != 0 ? highestTierOfSameCollected <= RARITY_TIER_MAP.getOrDefault(pair.right(), 0) : true;
        }).collect(Collectors.toMap(p -> ((Accessory)p.left()).id(), Function.identity(), (oldValue, newValue) -> newValue, Object2ObjectOpenHashMap::new));
        int magicalPower = 0;
        int hegeMp = 0;
        int abicaseMp = 0;
        int verySpecials = 0;
        int specials = 0;
        int mythics = 0;
        int legendaries = 0;
        int epics = 0;
        int rares = 0;
        int uncommons = 0;
        int commons = 0;
        Object2ObjectOpenHashMap validAccessories = collectedAccessories.object2ObjectEntrySet().stream().map(Map.Entry::getValue).filter(a -> {
            Accessory accessory = (Accessory)a.left();
            boolean hasGreaterTierOfSameFamily = collectedAccessories.object2ObjectEntrySet().stream().map(Map.Entry::getValue).map(Pair::left).filter(ca -> ca.family().isPresent()).filter(accessory::hasSameFamily).filter(ca -> ca.tier() > accessory.tier()).findAny().isPresent();
            return !hasGreaterTierOfSameFamily;
        }).filter(a -> {
            Accessory accessory = (Accessory)a.left();
            IntSummaryStatistics accessoryTierSummary = Accessories.getAccessories().entrySet().stream().map(Map.Entry::getValue).filter(ca -> ca.family().isPresent()).filter(accessory::hasSameFamily).mapToInt(Accessory::tier).summaryStatistics();
            boolean allAccessoriesFromFamilyAreTheSameTier = accessoryTierSummary.getMin() == accessory.tier() && accessoryTierSummary.getMax() == accessory.tier();
            int greatestHashCodeInFamily = collectedAccessories.object2ObjectEntrySet().stream().map(Map.Entry::getValue).map(Pair::left).filter(ca -> ca.family().isPresent()).filter(accessory::hasSameFamily).mapToInt(Accessory::hashCode).max().orElse(0);
            return allAccessoriesFromFamilyAreTheSameTier ? accessory.hashCode() == greatestHashCodeInFamily : true;
        }).collect(Collectors.toMap(p -> ((Accessory)p.left()).id(), Function.identity(), (oldValue, newValue) -> newValue, Object2ObjectOpenHashMap::new));
        for (Map.Entry accessory : validAccessories.entrySet()) {
            JsonObject crimsonIsleData;
            String id = (String)accessory.getKey();
            String rarity = (String)((Pair)accessory.getValue()).right();
            int mpToAdd = 0;
            switch (rarity) {
                case "VERY SPECIAL": {
                    mpToAdd = 5;
                    ++verySpecials;
                    break;
                }
                case "SPECIAL": {
                    mpToAdd = 3;
                    ++specials;
                    break;
                }
                case "MYTHIC": {
                    mpToAdd = 22;
                    ++mythics;
                    break;
                }
                case "LEGENDARY": {
                    mpToAdd = 16;
                    ++legendaries;
                    break;
                }
                case "EPIC": {
                    mpToAdd = 12;
                    ++epics;
                    break;
                }
                case "RARE": {
                    mpToAdd = 8;
                    ++rares;
                    break;
                }
                case "UNCOMMON": {
                    mpToAdd = 5;
                    ++uncommons;
                    break;
                }
                case "COMMON": {
                    mpToAdd = 3;
                    ++commons;
                    break;
                }
                default: {
                    LOGGER.warn("[Aaron's Mod] Unrecognized accessory rarity \"{}\", please report this!", (Object)rarity);
                }
            }
            if (id.equals("HEGEMONY_ARTIFACT")) {
                hegeMp = mpToAdd;
            }
            if (id.equals("ABICASE") && (crimsonIsleData = profile.getAsJsonObject("nether_island_player_data")) != null && crimsonIsleData.has("abiphone")) {
                JsonObject abiphone = crimsonIsleData.getAsJsonObject("abiphone");
                JsonArray activeContacts = abiphone.get("active_contacts").getAsJsonArray();
                abicaseMp = (int)Math.floor(activeContacts.size() / 2);
            }
            magicalPower += mpToAdd;
        }
        magicalPower += hegeMp;
        magicalPower += abicaseMp;
        if (profile.has("rift") && JsonHelper.getBoolean(riftAccess = profile.getAsJsonObject("rift").getAsJsonObject("access"), "consumed_prism").orElse(false).booleanValue()) {
            magicalPower += 11;
        }
        String selectedPower = JsonHelper.getString(accessoryBagStorage, "selected_power").orElse("None");
        Map<String, MagicalPower> magicalPowers = Accessories.getMagicalPowers();
        MagicalPower powerData = magicalPowers.getOrDefault(selectedPower, null);
        Object2FloatOpenHashMap stats = null;
        Object2FloatOpenHashMap<String> bonus = null;
        if (powerData != null) {
            double statsMult = STATS_MULT.applyAsDouble(magicalPower);
            stats = (Object2FloatOpenHashMap)class_156.method_654((Object)powerData.stats().clone(), m -> m.object2FloatEntrySet().stream().forEach(e -> e.setValue((float)Math.round((double)e.getFloatValue() * statsMult))));
            bonus = powerData.bonus();
        }
        Map tuningData = accessoryBagStorage.getAsJsonObject("tuning").getAsJsonObject("slot_0").asMap();
        List tunings = tuningData.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).getAsInt() != 0).map(entry -> MagicalPowerCommand.formatTuningStat((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt())).collect(Collectors.toList());
        int finalMagicalPower = magicalPower;
        Object2FloatOpenHashMap finalStats = stats;
        Object2FloatOpenHashMap<String> finalBonus = bonus;
        RenderHelper.runOnRenderThread(() -> {
            class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
            source.sendFeedback((class_2561)startText);
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Magical Power \u00bb ").method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(finalMagicalPower)).method_54663(colourProfile.highlightColour.getAsInt())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Selected Power \u00bb " + Functions.titleCase(selectedPower))).method_54663(colourProfile.infoColour.getAsInt()));
            if (powerData != null) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                finalStats.object2FloatEntrySet().stream().sorted(MagicalPowerCommand::compareStats).map(e -> MagicalPowerCommand.formatStatText((String)e.getKey(), e.getFloatValue())).forEachOrdered(arg_0 -> ((FabricClientCommandSource)source).sendFeedback(arg_0));
                source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                if (finalBonus.size() > 0) {
                    List bonuses = finalBonus.clone().object2FloatEntrySet().stream().map(e -> MagicalPowerCommand.formatStatText((String)e.getKey(), e.getFloatValue())).collect(Collectors.toList());
                    source.sendFeedback((class_2561)class_2561.method_43470((String)"(Unique Power Bonus)").method_54663(colourProfile.hoverColour.getAsInt()).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613(MagicalPowerCommand.getStatsBreakdown(bonuses)))));
                }
            } else {
                source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)"(Tunings)").method_27694(style -> style.method_36139(colourProfile.hoverColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613(MagicalPowerCommand.getStatsBreakdown(tunings)))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
    }

    private static class_2561 formatTuningStat(String stat, int tuningAmount) {
        return MagicalPowerCommand.formatStatText(stat, MagicalPowerCommand.scaleTuningStat(stat, tuningAmount));
    }

    private static class_2561 formatStatText(String stat, float amount) {
        String base = (Math.signum(amount) == 1.0f ? "+" : "") + Formatters.FLOAT_NUMBERS.format(amount);
        return switch (stat) {
            case "health" -> class_2561.method_43470((String)(base + "\u2764 Health")).method_27692(class_124.field_1061);
            case "defence", "defense" -> class_2561.method_43470((String)(base + "\u2748 Defence")).method_27692(class_124.field_1060);
            case "walk_speed" -> class_2561.method_43470((String)(base + "\u2726 Speed")).method_27692(class_124.field_1068);
            case "strength" -> class_2561.method_43470((String)(base + "\u2741 Strength")).method_27692(class_124.field_1061);
            case "critical_damage" -> class_2561.method_43470((String)(base + "\u2620 Crit Damage")).method_27692(class_124.field_1078);
            case "critical_chance" -> class_2561.method_43470((String)(base + "\u2623 Crit Chance")).method_27692(class_124.field_1078);
            case "attack_speed" -> class_2561.method_43470((String)(base + "\u2694 Bonus Attack Speed")).method_27692(class_124.field_1054);
            case "intelligence" -> class_2561.method_43470((String)(base + "\u270e Intelligence")).method_27692(class_124.field_1075);
            case "ferocity" -> class_2561.method_43470((String)(base + "\u2afd Ferocity")).method_27692(class_124.field_1061);
            case "ability_damage" -> class_2561.method_43470((String)(base + "\u0e51 Ability Damage")).method_27692(class_124.field_1061);
            case "true_defence", "true_defense" -> class_2561.method_43470((String)(base + "\u2742 True Defence")).method_27692(class_124.field_1068);
            case "combat_wisdom" -> class_2561.method_43470((String)(base + "\u262f Combat Wisdom")).method_27692(class_124.field_1062);
            case "vitality" -> class_2561.method_43470((String)(base + "\u2668 Vitality")).method_27692(class_124.field_1079);
            case "mending" -> class_2561.method_43470((String)(base + "\u2604 Mending")).method_27692(class_124.field_1060);
            default -> class_2561.method_43470((String)(base + " " + Functions.titleCase(stat.replace('_', ' ')))).method_27692(class_124.field_1080);
        };
    }

    private static float scaleTuningStat(String stat, int amount) {
        return switch (stat) {
            case "health" -> amount * 5;
            case "walk_speed" -> (float)amount * 1.5f;
            case "critical_chance" -> (float)amount * 0.2f;
            case "attack_speed" -> (float)amount * 0.3f;
            case "intelligence" -> amount * 2;
            default -> amount;
        };
    }

    private static class_2561 getStatsBreakdown(List<class_2561> list) {
        class_5250 breakdown = class_2561.method_43473();
        Iterator<class_2561> iterator = list.iterator();
        while (iterator.hasNext()) {
            class_5250 statText = (class_5250)iterator.next();
            if (iterator.hasNext()) {
                statText.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            }
            breakdown.method_10852((class_2561)statText);
        }
        return breakdown;
    }

    private static int compareStats(Object o1, Object o2) {
        List<String> order = List.of("health", "defence", "defense", "walk_speed", "strength", "intelligence", "critical_chance", "critical_damage", "attack_speed", "ability_damage", "true_defence", "true_defense", "ferocity", "vitality", "mending", "combat_wisdom");
        Comparator comparator = (s1, s2) -> Integer.compare(order.indexOf(s1), order.indexOf(s2));
        return comparator.compare((String)((Object2FloatMap.Entry)Object2FloatMap.Entry.class.cast(o1)).getKey(), (String)((Object2FloatMap.Entry)Object2FloatMap.Entry.class.cast(o2)).getKey());
    }

    private static class_2561 getRarityBreakdownText(String rarity, Object2ObjectOpenHashMap<String, String> accessoryMap) {
        int count = MagicalPowerCommand.countOfRarity(accessoryMap, rarity);
        int mpPer = switch (rarity) {
            case "VERY SPECIAL" -> 5;
            case "SPECIAL" -> 3;
            case "MYTHIC" -> 22;
            case "LEGENDARY" -> 16;
            case "EPIC" -> 12;
            case "RARE" -> 8;
            case "UNCOMMON" -> 5;
            case "COMMON" -> 3;
            default -> throw new IllegalArgumentException("Unexpected value: " + rarity);
        };
        return null;
    }

    private static int countOfRarity(Object2ObjectOpenHashMap<String, String> map, String rarity) {
        return (int)map.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(rarity)).count();
    }
}

