/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.Command;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.commands.SkyblockCommand;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.Cache;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.Functions;
import net.azureaaron.mod.utils.ItemUtils;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.mod.utils.Messages;
import net.azureaaron.mod.utils.Skyblock;
import net.azureaaron.mod.utils.networth.NetworthCalculator;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.azureaaron.networth.PetCalculator;
import net.azureaaron.networth.item.PetInfo;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class NetworthCommand
extends SkyblockCommand {
    private static final Command INSTANCE = new NetworthCommand();
    private static final Logger LOGGER = LogUtils.getLogger();

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(INSTANCE::register);
        }
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"networth").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"nw").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
    }

    @Override
    public void print(FabricClientCommandSource source, JsonObject body, String name, String uuid) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        JsonObject profile = body.getAsJsonObject("members").getAsJsonObject(uuid);
        boolean inventoryEnabled = Skyblock.isInventoryApiEnabled(JsonHelper.getObject(profile, "inventory").orElseGet(JsonObject::new));
        if (!inventoryEnabled) {
            source.sendError((class_2561)Messages.INVENTORY_API_DISABLED_ERROR.get());
            return;
        }
        Object2DoubleOpenHashMap armour = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap equipment = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap inventory = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap enderChests = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap storage = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap accessories = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap wardrobe = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap pets = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap essence = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap sacks = new Object2DoubleOpenHashMap();
        try {
            armour.putAll(NetworthCommand.calculateNetworth4Items(ItemUtils.parseCompressedItemData(JsonHelper.getString(profile, "inventory.inv_armor.data").orElseThrow())));
            equipment.putAll(NetworthCommand.calculateNetworth4Items(ItemUtils.parseCompressedItemData(JsonHelper.getString(profile, "inventory.equipment_contents.data").orElseThrow())));
            inventory.putAll(NetworthCommand.calculateNetworth4Items(ItemUtils.parseCompressedItemData(JsonHelper.getString(profile, "inventory.inv_contents.data").orElseThrow())));
            enderChests.putAll(NetworthCommand.calculateNetworth4Items(ItemUtils.parseCompressedItemData(JsonHelper.getString(profile, "inventory.ender_chest_contents.data").orElseThrow())));
            accessories.putAll(NetworthCommand.calculateNetworth4Items(ItemUtils.parseCompressedItemData(JsonHelper.getString(profile, "inventory.bag_contents.talisman_bag.data").orElseThrow())));
            wardrobe.putAll(NetworthCommand.calculateNetworth4Items(ItemUtils.parseCompressedItemData(JsonHelper.getString(profile, "inventory.wardrobe_contents.data").orElseThrow())));
            JsonObject backpacks = JsonHelper.getObject(profile, "inventory.backpack_contents").orElseGet(JsonObject::new);
            for (String key : backpacks.keySet()) {
                String backpackData = JsonHelper.getString(backpacks, key + ".data").orElseThrow();
                Object2DoubleMap<class_1799> calculations = NetworthCommand.calculateNetworth4Items(ItemUtils.parseCompressedItemData(backpackData));
                storage.putAll(calculations);
            }
            JsonArray profilePets = JsonHelper.getArray(profile, "pets_data.pets").orElseGet(JsonArray::new);
            pets.putAll((Map)((Object2DoubleMap)profilePets.asList().stream().map(JsonElement::getAsJsonObject).map(JsonHelper::clearNullValues).map(petInfo -> new Dynamic((DynamicOps)JsonOps.INSTANCE, petInfo)).map(arg_0 -> ((Codec)PetInfo.CODEC).parse(arg_0)).map(DataResult::getOrThrow).collect(Collectors.toMap(Function.identity(), petInfo -> NetworthCalculator.calculatePetNetworth(petInfo).price(), (a, b) -> a, Object2DoubleOpenHashMap::new))));
            JsonObject essences = JsonHelper.getObject(profile, "currencies.essence").orElseGet(JsonObject::new);
            for (Object essenceType : essences.keySet()) {
                int amount = JsonHelper.getInt(essences, (String)essenceType + ".current").orElse(0);
                essence.put(essenceType, NetworthCalculator.calculateEssenceNetworth((String)essenceType, amount).price());
            }
            JsonObject sacksItems = JsonHelper.getObject(profile, "inventory.sacks_counts").orElseGet(JsonObject::new);
            for (Map.Entry sackItem : sacksItems.entrySet()) {
                int amount = ((JsonElement)sackItem.getValue()).getAsInt();
                sacks.put((Object)((String)sackItem.getKey()), NetworthCalculator.calculateSackItemNetworth((String)sackItem.getKey(), amount).price());
            }
        }
        catch (Exception e) {
            LOGGER.error("[Aaron's Mod Networth Command] Failed to calculate networth :(", (Throwable)e);
            source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"Failed to calculate this player's networth!").method_27692(class_124.field_1061)));
            return;
        }
        double armourValue = armour.values().doubleStream().sum();
        double equipmentValue = equipment.values().doubleStream().sum();
        double inventoryValue = inventory.values().doubleStream().sum();
        double enderChestsValue = enderChests.values().doubleStream().sum();
        double storageValue = storage.values().doubleStream().sum();
        double accessoriesValue = accessories.values().doubleStream().sum();
        double petsValue = pets.values().doubleStream().sum();
        double wardrobeValue = wardrobe.values().doubleStream().sum();
        double sacksValue = sacks.values().doubleStream().sum();
        double essenceValue = essence.values().doubleStream().sum();
        double purse = JsonHelper.getDouble(profile, "currencies.coin_purse").orElse(0.0);
        double bank = JsonHelper.getDouble(body, "banking.balance").orElse(0.0);
        double overallValue = armourValue + equipmentValue + inventoryValue + enderChestsValue + storageValue + accessoriesValue + petsValue + wardrobeValue + sacksValue + essenceValue + purse + bank;
        RenderHelper.runOnRenderThread(() -> NetworthCommand.lambda$print$28(colourProfile, name, source, overallValue, armourValue, (Object2DoubleMap)armour, equipmentValue, (Object2DoubleMap)equipment, inventoryValue, (Object2DoubleMap)inventory, enderChestsValue, (Object2DoubleMap)enderChests, storageValue, (Object2DoubleMap)storage, accessoriesValue, (Object2DoubleMap)accessories, petsValue, (Object2DoubleMap)pets, wardrobeValue, (Object2DoubleMap)wardrobe, sacksValue, (Object2DoubleMap)sacks, essenceValue, (Object2DoubleMap)essence, bank, purse));
    }

    private static Object2DoubleMap<class_1799> calculateNetworth4Items(List<class_1799> items) {
        Object2DoubleOpenHashMap calculations = new Object2DoubleOpenHashMap();
        for (class_1799 stack : items) {
            if (stack.method_7960()) continue;
            calculations.put((Object)stack, NetworthCalculator.calculateItemNetworth(stack).price());
        }
        return calculations;
    }

    private static <T> class_2568 getHover(double totalValue, @Nullable Object2DoubleMap<T> objects, @Nullable Function<T, class_2561> textifier) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        class_5250 hoverText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("Exact Value \u00bb " + Formatters.INTEGER_NUMBERS.format(totalValue))).method_54663(colourProfile.infoColour.getAsInt()));
        if (objects != null && textifier != null) {
            SequencedCollection sortedEntries = objects.object2DoubleEntrySet().stream().sorted(Comparator.comparingDouble(Object2DoubleMap.Entry::getDoubleValue)).toList().reversed();
            for (Object2DoubleMap.Entry entry : sortedEntries.subList(0, Math.min(sortedEntries.size(), 5))) {
                hoverText.method_27693("\n");
                hoverText.method_10852(textifier.apply(entry.getKey()));
                hoverText.method_27693(" - ");
                hoverText.method_10852((class_2561)class_2561.method_43470((String)Formatters.SHORT_FLOAT_NUMBERS.format(entry.getDoubleValue())).method_54663(colourProfile.infoColour.getAsInt()));
            }
        }
        return new class_2568.class_10613((class_2561)hoverText);
    }

    private static class_2561 formatPet(PetInfo petInfo) {
        class_124 nameColour = switch (petInfo.tier()) {
            case "MYTHIC" -> class_124.field_1076;
            case "LEGENDARY" -> class_124.field_1065;
            case "EPIC" -> class_124.field_1064;
            case "RARE" -> class_124.field_1078;
            case "UNCOMMON" -> class_124.field_1060;
            case "COMMON" -> class_124.field_1068;
            default -> class_124.field_1080;
        };
        String formattedName = Functions.titleCase(petInfo.type().replace('_', ' '));
        class_5250 text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("[Lvl " + PetCalculator.calculatePetLevel((PetInfo)petInfo).leftInt() + "] ")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)formattedName).method_27692(nameColour));
        return text;
    }

    private static class_2561 formatSacks(String itemId) {
        String name = Cache.ITEM_NAMES.get(itemId);
        return name != null ? class_2561.method_43470((String)name) : class_2561.method_43470((String)Functions.titleCase(itemId.replace('_', ' ')));
    }

    private static class_2561 formatEssence(String essenceType) {
        int essenceColour = switch (essenceType) {
            case "WITHER" -> 0x2B2B2A;
            case "SPIDER" -> 4940922;
            case "UNDEAD" -> 12548750;
            case "DRAGON" -> 0xF52F2F;
            case "GOLD" -> 15580473;
            case "DIAMOND" -> 7728368;
            case "ICE" -> 9754359;
            case "CRIMSON" -> 15885329;
            default -> 0;
        };
        return class_2561.method_43470((String)Functions.titleCase(essenceType)).method_54663(essenceColour).method_10852((class_2561)class_2561.method_43470((String)" Essence"));
    }

    private static /* synthetic */ void lambda$print$28(Colour.ColourProfiles colourProfile, String name, FabricClientCommandSource source, double overallValue, double armourValue, Object2DoubleMap armour, double equipmentValue, Object2DoubleMap equipment, double inventoryValue, Object2DoubleMap inventory, double enderChestsValue, Object2DoubleMap enderChests, double storageValue, Object2DoubleMap storage, double accessoriesValue, Object2DoubleMap accessories, double petsValue, Object2DoubleMap pets, double wardrobeValue, Object2DoubleMap wardrobe, double sacksValue, Object2DoubleMap sacks, double essenceValue, Object2DoubleMap essence, double bank, double purse) {
        class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
        source.sendFeedback((class_2561)startText);
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Networth \u00bb " + Formatters.INTEGER_NUMBERS.format(overallValue) + " (" + Formatters.SHORT_FLOAT_NUMBERS.format(overallValue) + ")")).method_54663(colourProfile.infoColour.getAsInt()));
        source.sendFeedback((class_2561)class_2561.method_43470((String)""));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Armour \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(armourValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(armourValue, armour, class_1799::method_7964))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Equipment \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(equipmentValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(equipmentValue, equipment, class_1799::method_7964))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Inventory \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(inventoryValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(inventoryValue, inventory, class_1799::method_7964))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Ender Chests \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(enderChestsValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(enderChestsValue, enderChests, class_1799::method_7964))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Storage \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(storageValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(storageValue, storage, class_1799::method_7964))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Accessories \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(accessoriesValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(accessoriesValue, accessories, class_1799::method_7964))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Pets \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(petsValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(petsValue, pets, NetworthCommand::formatPet))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Wardrobe \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(wardrobeValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(wardrobeValue, wardrobe, class_1799::method_7964))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Sacks \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(sacksValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(sacksValue, sacks, NetworthCommand::formatSacks))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Essence \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(essenceValue))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(essenceValue, essence, NetworthCommand::formatEssence))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)""));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Bank \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(bank))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(bank, null, null))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Purse \u00bb " + Formatters.SHORT_FLOAT_NUMBERS.format(purse))).method_54663(colourProfile.infoColour.getAsInt()).method_27694(style -> style.method_10949(NetworthCommand.getHover(purse, null, null))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
    }
}

