/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.skyblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.time.Instant;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.commands.Command;
import net.azureaaron.mod.commands.CommandSystem;
import net.azureaaron.mod.commands.SkyblockCommand;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.Functions;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.mod.utils.Levelling;
import net.azureaaron.mod.utils.Skyblock;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class ProfileCommand
extends SkyblockCommand {
    private static final Command INSTANCE = new ProfileCommand();

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientCommandRegistrationCallback.EVENT.register(INSTANCE::register);
        }
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"profile").executes(context -> CommandSystem.handleSelf4Skyblock(this, (FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])CommandSystem.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(context -> CommandSystem.handlePlayer4Skyblock(this, (FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
    }

    @Override
    public void print(FabricClientCommandSource source, JsonObject body, String name, String uuid) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        JsonObject profile = body.getAsJsonObject("members").getAsJsonObject(uuid);
        boolean bankingEnabled = body.has("banking");
        boolean skillsEnabled = Skyblock.isSkillsApiEnabled(profile);
        int farmingLevelCap = JsonHelper.getInt(profile, "jacobs_contest.perks.farming_level_cap").orElse(0);
        int tamingLevelCap = JsonHelper.getArray(profile, "pets_data.pet_care.pet_types_sacrificed").orElseGet(JsonArray::new).size();
        String bank = Formatters.DOUBLE_NUMBERS.format(JsonHelper.getLong(body, "banking.balance").orElse(0L));
        String purse = Formatters.DOUBLE_NUMBERS.format(JsonHelper.getLong(profile, "currencies.coin_purse").orElse(0L));
        long firstJoinTimestamp = profile.getAsJsonObject("profile").get("first_join").getAsLong();
        long firstJoinRelative = System.currentTimeMillis() - firstJoinTimestamp;
        int level = Levelling.getSkyblockLevel(JsonHelper.getInt(profile, "leveling.experience").orElse(0));
        JsonObject playerData = profile.getAsJsonObject("player_data");
        int alchemyLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_ALCHEMY").orElse(0L), Levelling.Skills.ALCHEMY, 0);
        int carpentryLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_CARPENTRY").orElse(0L), Levelling.Skills.CARPENTRY, 0);
        int combatLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_COMBAT").orElse(0L), Levelling.Skills.COMBAT, 0);
        int enchantingLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_ENCHANTING").orElse(0L), Levelling.Skills.ENCHANTING, 0);
        int farmingLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_FARMING").orElse(0L), Levelling.Skills.FARMING, farmingLevelCap);
        int fishingLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_FISHING").orElse(0L), Levelling.Skills.FISHING, 0);
        int foragingLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_FORAGING").orElse(0L), Levelling.Skills.FORAGING, 0);
        int miningLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_MINING").orElse(0L), Levelling.Skills.MINING, 0);
        int runecraftingLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_RUNECRAFTING").orElse(0L), Levelling.Skills.RUNECRAFTING, 0);
        int socialLevel = Levelling.getSkillLevel(Skyblock.calculateProfileSocialXp(body), Levelling.Skills.SOCIAL, 0);
        int tamingLevel = Levelling.getSkillLevel(JsonHelper.getLong(playerData, "experience.SKILL_TAMING").orElse(0L), Levelling.Skills.TAMING, tamingLevelCap);
        float skillAverage = (float)(alchemyLevel + carpentryLevel + combatLevel + enchantingLevel + farmingLevel + fishingLevel + foragingLevel + miningLevel + tamingLevel) / 9.0f;
        JsonObject slayerBosses = profile.has("slayer") ? profile.getAsJsonObject("slayer").getAsJsonObject("slayer_bosses") : null;
        int revenantHorrorLevel = Levelling.getSlayerLevel(JsonHelper.getInt(slayerBosses, "zombie.xp").orElse(0), Levelling.Slayers.REVENANT_HORROR);
        int tarantulaBroodfatherLevel = Levelling.getSlayerLevel(JsonHelper.getInt(slayerBosses, "spider.xp").orElse(0), Levelling.Slayers.TARANTULA_BROODFATHER);
        int svenPackmasterLevel = Levelling.getSlayerLevel(JsonHelper.getInt(slayerBosses, "wolf.xp").orElse(0), Levelling.Slayers.SVEN_PACKMASTER);
        int voidgloomSeraphLevel = Levelling.getSlayerLevel(JsonHelper.getInt(slayerBosses, "enderman.xp").orElse(0), Levelling.Slayers.VOIDGLOOM_SERAPH);
        int infernoDemonlordLevel = Levelling.getSlayerLevel(JsonHelper.getInt(slayerBosses, "blaze.xp").orElse(0), Levelling.Slayers.INFERNO_DEMONLORD);
        int riftstalkerBloodfiendLevel = Levelling.getSlayerLevel(JsonHelper.getInt(slayerBosses, "vampire.xp").orElse(0), Levelling.Slayers.RIFTSTALKER_BLOODFIEND);
        RenderHelper.runOnRenderThread(() -> {
            class_5250 startText = class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"[- ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_36139(colourProfile.secondaryColour.getAsInt()).method_10982(Boolean.valueOf(true)).method_36140(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)" -]").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"     ").method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt())).method_27694(style -> style.method_36140(Boolean.valueOf(true)))));
            source.sendFeedback((class_2561)startText);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Profile \u00bb " + Functions.titleCase(body.get("cute_name").getAsString()))).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Joined \u00bb " + Formatters.toRelativeTime(firstJoinRelative).greatest())).method_27694(style -> style.method_36139(colourProfile.infoColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)Formatters.DATE_FORMATTER.format(Instant.ofEpochMilli(firstJoinTimestamp))).method_27694(style1 -> style1.method_36139(colourProfile.infoColour.getAsInt()))))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Level \u00bb " + level)).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            if (bankingEnabled) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Bank \u00bb " + bank)).method_54663(colourProfile.infoColour.getAsInt()));
            } else {
                source.sendFeedback((class_2561)class_2561.method_43470((String)"Bank \u00bb ").method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)"Api Disabled!")));
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Purse \u00bb " + purse)).method_54663(colourProfile.infoColour.getAsInt()));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            if (skillsEnabled) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Skill Average \u00bb " + Formatters.FLOAT_NUMBERS.format(skillAverage))).method_27694(style -> style.method_36139(colourProfile.infoColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Alchemy \u00bb " + String.valueOf(alchemyLevel) + "\n")).method_54663(colourProfile.infoColour.getAsInt()).method_27693("Carpentry \u00bb " + carpentryLevel + "\n").method_27693("Combat \u00bb " + combatLevel + "\n").method_27693("Enchanting \u00bb " + enchantingLevel + "\n").method_27693("Farming \u00bb " + farmingLevel + "\n").method_27693("Fishing \u00bb " + fishingLevel + "\n").method_27693("Foraging \u00bb " + foragingLevel + "\n").method_27693("Mining \u00bb " + miningLevel + "\n").method_27693("Taming \u00bb " + tamingLevel)))));
                source.sendFeedback((class_2561)class_2561.method_43470((String)"(Cosmetic Skills)").method_27694(style -> style.method_36139(colourProfile.hoverColour.getAsInt()).method_10978(Boolean.valueOf(true)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Runecrafting \u00bb " + runecraftingLevel + "\n")).method_27694(style1 -> style1.method_36139(colourProfile.infoColour.getAsInt()).method_10978(Boolean.valueOf(false))).method_27693("Social \u00bb " + socialLevel)))));
            } else {
                source.sendFeedback((class_2561)class_2561.method_43470((String)"Skill Average \u00bb ").method_54663(colourProfile.infoColour.getAsInt()).method_10852((class_2561)class_2561.method_43470((String)"Api Disabled!")));
                source.sendFeedback((class_2561)class_2561.method_43470((String)"(Cosmetic Skills)").method_27694(style -> style.method_36139(colourProfile.hoverColour.getAsInt()).method_10978(Boolean.valueOf(true)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Api Disabled!").method_27694(style1 -> style1.method_36139(colourProfile.infoColour.getAsInt()).method_10978(Boolean.valueOf(false)))))));
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Slayers \u00bb " + revenantHorrorLevel + " \u2022 " + tarantulaBroodfatherLevel + " \u2022 " + svenPackmasterLevel + " \u2022 " + voidgloomSeraphLevel + " \u2022 " + infernoDemonlordLevel + " \u2022 " + riftstalkerBloodfiendLevel)).method_27694(style -> style.method_36139(colourProfile.infoColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Revenant Horror \u00bb " + revenantHorrorLevel + "\n")).method_54663(colourProfile.infoColour.getAsInt()).method_27693("Tarantula Broodfather \u00bb " + tarantulaBroodfatherLevel + "\n").method_27693("Sven Packmaster \u00bb " + svenPackmasterLevel + "\n").method_27693("Voidgloom Seraph \u00bb " + voidgloomSeraphLevel + "\n").method_27693("Inferno Demonlord \u00bb " + infernoDemonlordLevel + "\n").method_27693("Riftstalker Bloodfiend \u00bb " + riftstalkerBloodfiendLevel)))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)CommandSystem.getEndSpaces((class_2561)startText)).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
    }
}

